# ExtensionEETISUnauthorizedProductRequest - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISUnauthorizedProductRequest**

## Extension: ExtensionEETISUnauthorizedProductRequest 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-unauthorized-product-request | *Version*:1.0.0 |
| Draft as of 2024-02-21 | *Computable Name*:ExtensionEETISUnauthorizedProductRequest |

Müügiloata ravimi taotlus. Used for requesting marketing permit for unauthorized medication.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* Examples for this Extension: [MedicationRequest/prescription-adrenalin-pos-dec](MedicationRequest-prescription-adrenalin-pos-dec.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-unauthorized-product-request)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-unauthorized-product-request.csv), [Excel](StructureDefinition-ee-tis-unauthorized-product-request.xlsx), [Schematron](StructureDefinition-ee-tis-unauthorized-product-request.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-unauthorized-product-request",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-unauthorized-product-request",
  "version" : "1.0.0",
  "name" : "ExtensionEETISUnauthorizedProductRequest",
  "status" : "draft",
  "date" : "2024-02-21T12:14:43.6691324+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Müügiloata ravimi taotlus. Used for requesting marketing permit for unauthorized medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    },
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Müügiloata ravimi taotlus.",
        "definition" : "Used for requesting marketing permit for unauthorized medication."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 2
      },
      {
        "id" : "Extension.extension:requestNumber",
        "path" : "Extension.extension",
        "sliceName" : "requestNumber",
        "short" : "Request number for unauthorized medication marketing request",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:requestNumber.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:requestNumber.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "requestNumber"
      },
      {
        "id" : "Extension.extension:requestNumber.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Marketing request decision number given by Ravimiamet. Every marketing request has its own unique number.",
        "definition" : "Müügiloata ravimi otsuse number, mille annab Ravimiamet.",
        "type" : [
          {
            "code" : "id"
          }
        ]
      },
      {
        "id" : "Extension.extension:requestReason",
        "path" : "Extension.extension",
        "sliceName" : "requestReason",
        "short" : "Reason for unauthorized medication marketing request",
        "definition" : "Müügiloata ravimi taotluse põhjus",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:requestReason.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:requestReason.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "requestReason"
      },
      {
        "id" : "Extension.extension:requestReason.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Myygiloata ravimi pohjendus. LOEND",
          "valueSet" : "https://fhir.ee/ValueSet/myygiloata-ravimi-pohjendus"
        }
      },
      {
        "id" : "Extension.extension:requestStatus",
        "path" : "Extension.extension",
        "sliceName" : "requestStatus",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:requestStatus.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:requestStatus.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "requestStatus"
      },
      {
        "id" : "Extension.extension:requestStatus.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Unauthorized medication marketing request ststus\r\nPositiivne | Negatiivne",
        "definition" : "Taotlus rahuldati või taotlust ei rahuldatud.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Müügiloata ravimi taotluse staatuse loend",
          "valueSet" : "https://fhir.ee/ValueSet/myygiloata-ravimi-taotluse-staatus"
        }
      },
      {
        "id" : "Extension.extension:requestDate",
        "path" : "Extension.extension",
        "sliceName" : "requestDate",
        "short" : "Date when the request was made.",
        "definition" : "Müügiloata ravimi taotluse kuupäev.",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:requestDate.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:requestDate.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "requestDate"
      },
      {
        "id" : "Extension.extension:requestDate.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Extension.extension:requestNegDecision",
        "path" : "Extension.extension",
        "sliceName" : "requestNegDecision",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:requestNegDecision.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:requestNegDecision.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "requestNegDecision"
      },
      {
        "id" : "Extension.extension:requestNegDecision.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Reason for a declining the request.",
        "definition" : "Negatiivse otsuse põhjendus. LOEND",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "Müügiloata ravimi taotluse keelduva otsuse põhjendused",
          "valueSet" : "https://fhir.ee/ValueSet/myygiloata-ravimi-neg-otsuse-pohjendus"
        }
      },
      {
        "id" : "Extension.extension:requestReasonText",
        "path" : "Extension.extension",
        "sliceName" : "requestReasonText",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:requestReasonText.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:requestReasonText.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "requestReasonText"
      },
      {
        "id" : "Extension.extension:requestReasonText.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Reason in free form text. If the reason for requesting unauthorized medicine is not in the valueset there must be free form explanation for the request.",
        "definition" : "Negatiivse otsuse põhjendus kui loendist on valitud 'muu'",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-unauthorized-product-request"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
