# ExtensionEETISSubstitution - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISSubstitution**

## Extension: ExtensionEETISSubstitution 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-substitution | *Version*:1.0.0 |
| Draft as of 2024-02-21 | *Computable Name*:ExtensionEETISSubstitution |

Asendamine lubatud. Reason for not allowing the substitution of medication.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)
* Examples for this Extension: [MedicationStatement/MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md), [MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md), [MedicationStatement/MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md), [MedicationStatement/MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md) and [MedicationStatement/MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-substitution)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-substitution.csv), [Excel](StructureDefinition-ee-tis-substitution.xlsx), [Schematron](StructureDefinition-ee-tis-substitution.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-substitution",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-substitution",
  "version" : "1.0.0",
  "name" : "ExtensionEETISSubstitution",
  "status" : "draft",
  "date" : "2024-02-21T07:24:08.5899288+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Asendamine lubatud. Reason for not allowing the substitution of medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Reason for not allowing the substitution of medication.",
        "definition" : "Asendamise mitte-lubamine"
      },
      {
        "id" : "Extension.extension:substitutionAllowed",
        "path" : "Extension.extension",
        "sliceName" : "substitutionAllowed",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:substitutionAllowed.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:substitutionAllowed.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "substitutionAllowed"
      },
      {
        "id" : "Extension.extension:substitutionAllowed.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "true - substitution is allowed\r\nfalse -substitution NOT allowed, provide reason",
        "definition" : "Vaikimisi on asendamine lubatud kõikide ravimite puhul",
        "min" : 1,
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.extension:substitutionAllowedReason",
        "path" : "Extension.extension",
        "sliceName" : "substitutionAllowedReason",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:substitutionAllowedReason.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:substitutionAllowedReason.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "substitutionAllowedReason"
      },
      {
        "id" : "Extension.extension:substitutionAllowedReason.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "If substitution is not allowed one must choose the reason for it from the ValueSet.",
        "definition" : "Juhul kui asendamine pole lubatud peab loendist valima põhjuse, miks.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "Reason for NOT allowing substitution",
          "valueSet" : "https://fhir.ee/ValueSet/ravimi-asendamatuse-pohjus"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-substitution"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
