# ExtensionEETISRenalFailureWarning - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISRenalFailureWarning**

## Extension: ExtensionEETISRenalFailureWarning 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-renal-failure-warning | *Version*:1.0.0 |
| Draft as of 2024-02-23 | *Computable Name*:ExtensionEETISRenalFailureWarning |

Nõusolek neerufunktsiooni hoiatustega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered renal function failure warnings and consented with them.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md)
* Examples for this Extension: [List/listMatiMeri3](List-listMatiMeri3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-renal-failure-warning)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-renal-failure-warning.csv), [Excel](StructureDefinition-ee-tis-renal-failure-warning.xlsx), [Schematron](StructureDefinition-ee-tis-renal-failure-warning.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-renal-failure-warning",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-renal-failure-warning",
  "version" : "1.0.0",
  "name" : "ExtensionEETISRenalFailureWarning",
  "status" : "draft",
  "date" : "2024-02-23T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Nõusolek neerufunktsiooni hoiatustega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered renal function failure warnings and consented with them.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "List"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Consent with renal function warnings.",
        "definition" : "Nõusolek neerufunktsiooni hoiatustega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered renal function failure warnings and consented with them."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-renal-failure-warning"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Whether or not practitioner agrees with renal function warnings. \r\n\r\nIf true indicates that practitioner is aware and agrees with warnings about renal function failure.",
        "definition" : "Ravimi väljakirjutaja nõusolek neerufunktsiooni hoiatusega.",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
