# ExtensionEETISRelatedObservationOrCondition - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISRelatedObservationOrCondition**

## Extension: ExtensionEETISRelatedObservationOrCondition 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-related-observation-or-condition | *Version*:1.0.0 |
| Draft as of 2024-02-23 | *Computable Name*:ExtensionEETISRelatedObservationOrCondition |

Seotud analüüs/test/uuring, mis on võib mõjutada neerufunktsiooni.This extension is used in to express renal function related observation/condition.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISRenalFailureDS](StructureDefinition-ee-tis-renal-failure-ds.md)
* Examples for this Extension: [ClinicalUseDefinition/renal-function-failure](ClinicalUseDefinition-renal-function-failure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-related-observation-or-condition)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-related-observation-or-condition.csv), [Excel](StructureDefinition-ee-tis-related-observation-or-condition.xlsx), [Schematron](StructureDefinition-ee-tis-related-observation-or-condition.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-related-observation-or-condition",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-related-observation-or-condition",
  "version" : "1.0.0",
  "name" : "ExtensionEETISRelatedObservationOrCondition",
  "status" : "draft",
  "date" : "2024-02-23T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Seotud analüüs/test/uuring, mis on võib mõjutada neerufunktsiooni.This extension is used in to express renal function related observation/condition.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClinicalUseDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Observation/Condition which triggers renal function alert.",
        "definition" : "Kasutusel viitamaks observationile/conditionile, mis mõjutavad neerufunktsiooni."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-related-observation-or-condition"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Observation/Condition which may trigger renal function alerts",
        "definition" : "Observation/condition, mis kutsub esile neerufunktisooni muutuse languse ning määratud ravim võib vajada korrigeerimist",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/Condition"
            ]
          }
        ]
      }
    ]
  }
}

```
