# EETISReimbursementTask - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISReimbursementTask**

## Resource Profile: EETISReimbursementTask 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-reimbursement-task | *Version*:1.0.0 |
| Draft as of 2024-02-05 | *Computable Name*:EETISReimbursementTask |

 
Soodusmäära küsimine. Task is for the practitioner to ask reimbursement rates for prescription medicine. The MedicationStatement with its medication is sent to the Estonian Prescription Center and in return the practitoner recieves reimbursement rate (with additional explanation) for the medication. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-reimbursement-task)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-reimbursement-task.csv), [Excel](StructureDefinition-ee-tis-reimbursement-task.xlsx), [Schematron](StructureDefinition-ee-tis-reimbursement-task.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-reimbursement-task",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-task",
  "version" : "1.0.0",
  "name" : "EETISReimbursementTask",
  "status" : "draft",
  "date" : "2024-02-05T11:53:03.4000794+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Soodusmäära küsimine. Task is for the practitioner to ask reimbursement rates for prescription medicine. The MedicationStatement with its medication is sent to the Estonian Prescription Center and in return the practitoner recieves reimbursement rate (with additional explanation) for the medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task",
        "definition" : "Task is for the practitioner to ask reimbursement rates for prescription medicine. The MedicationStatement with its medication is sent to the Estonian Prescription Center and in return the practitoner recieves reimbursement rate (with additional explanation) for the medication."
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
            ]
          }
        ]
      },
      {
        "id" : "Task.input.value[x]",
        "path" : "Task.input.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
            ]
          }
        ]
      },
      {
        "id" : "Task.output.value[x]",
        "path" : "Task.output.value[x]",
        "short" : "Response of reimbursement rate with different values",
        "definition" : "Soodusmäära vastus.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-task-response-parameters"
            ]
          }
        ]
      }
    ]
  }
}

```
