# ExtensionEETISReimbursementRate - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISReimbursementRate**

## Extension: ExtensionEETISReimbursementRate 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate | *Version*:1.0.0 |
| Draft as of 2024-01-31 | *Computable Name*:ExtensionEETISReimbursementRate |

Soodustuse määr ja tingimused (soodusravimite nimekirja järgi). For representation of the reimbursement rate and reason of prescription medicine. Speciality of prescriber if available and necessary

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md), [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* Examples for this Extension: [MedicationDispense/dispensation-alprazolam](MedicationDispense-dispensation-alprazolam.md), [MedicationDispense/dispensation-metformin](MedicationDispense-dispensation-metformin.md), [MedicationRequest/prescription-adrenalin-pos-dec](MedicationRequest-prescription-adrenalin-pos-dec.md), [MedicationRequest/prescription-alprazolam](MedicationRequest-prescription-alprazolam.md)...Show 7 more,[MedicationRequest/prescription-cancelled](MedicationRequest-prescription-cancelled.md),[MedicationRequest/prescription-metformin](MedicationRequest-prescription-metformin.md),[MedicationStatement/MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md),[MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md),[MedicationStatement/MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md),[MedicationStatement/MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md)and[MedicationStatement/MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-reimbursement-rate)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-reimbursement-rate.csv), [Excel](StructureDefinition-ee-tis-reimbursement-rate.xlsx), [Schematron](StructureDefinition-ee-tis-reimbursement-rate.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-reimbursement-rate",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate",
  "version" : "1.0.0",
  "name" : "ExtensionEETISReimbursementRate",
  "status" : "draft",
  "date" : "2024-01-31T14:08:33.4764521+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Soodustuse määr ja tingimused (soodusravimite nimekirja järgi). For representation of the reimbursement rate and reason of prescription medicine. Speciality of prescriber if available and necessary",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    },
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    },
    {
      "type" : "element",
      "expression" : "MedicationDispense"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Reimbursement rate and reason of prescription medicine. Also speciality of prescriber if available.",
        "definition" : "Ravimi soodustuse määr protsentides Retseptikeskuse loendist \"Soodustuste määrad\" ning tingimused \"Vajalikud tingimused\" -loendist soodustuse saamiseks. Juhul kui retseptid genereeritakse, siis ka soodustuse määraja erialakood."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "min" : 1
      },
      {
        "id" : "Extension.extension:reimbursementRate",
        "path" : "Extension.extension",
        "sliceName" : "reimbursementRate",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:reimbursementRate.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:reimbursementRate.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "reimbursementRate"
      },
      {
        "id" : "Extension.extension:reimbursementRate.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Reimbursement rate of prescription medicine.\r\n0 | 50 | 75 | 90 | 100",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "Retsepti soodustuse määr. Loend",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-soodustuse-maar"
        }
      },
      {
        "id" : "Extension.extension:reimbursementCondition",
        "path" : "Extension.extension",
        "sliceName" : "reimbursementCondition",
        "short" : "NB! This is fake cs/VS! Just a name for system. Condition according to the list of reimbursed pharmaceuticals. Code from Retseptikeskus and description as display in text field.",
        "definition" : "\"Vajalikud tingimused\"loendist kood ning kirjeldus. Soodusravimite loetelule vastav tingimus.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:reimbursementCondition.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:reimbursementCondition.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "reimbursementCondition"
      },
      {
        "id" : "Extension.extension:reimbursementCondition.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "\"Vajalikud tingimused -loend\" retseptikeskusest",
          "valueSet" : "https://fhir.ee/ValueSet/ravimi-soodustuse-vajalikud-tingimused"
        }
      },
      {
        "id" : "Extension.extension:reimbursementSpeciality",
        "path" : "Extension.extension",
        "sliceName" : "reimbursementSpeciality",
        "short" : "Speciality when prescribing medicine is required as some specialities may have right for a higher reimbursement rate than others.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:reimbursementSpeciality.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:reimbursementSpeciality.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "reimbursementSpeciality"
      },
      {
        "id" : "Extension.extension:reimbursementSpeciality.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "description" : "\"Erialade -loend\"",
          "valueSet" : "https://fhir.ee/ValueSet/erialad"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
