# EETISPrescriptionDispense - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISPrescriptionDispense**

## Resource Profile: EETISPrescriptionDispense 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-prescription-dispense | *Version*:1.0.0 |
| Draft as of 2024-01-31 | *Computable Name*:EETISPrescriptionDispense |

 
Ravimi väljastamine. When the medication prescribed is dispensed in pharmacy. 

**Usages:**

* Examples for this Profile: [MedicationDispense/dispensation-alprazolam](MedicationDispense-dispensation-alprazolam.md) and [MedicationDispense/dispensation-metformin](MedicationDispense-dispensation-metformin.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-prescription-dispense)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-prescription-dispense.csv), [Excel](StructureDefinition-ee-tis-prescription-dispense.xlsx), [Schematron](StructureDefinition-ee-tis-prescription-dispense.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-prescription-dispense",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-dispense",
  "version" : "1.0.0",
  "name" : "EETISPrescriptionDispense",
  "status" : "draft",
  "date" : "2024-01-31T14:08:33.4764521+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimi väljastamine. When the medication prescribed is dispensed in pharmacy.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "rx-dispense-rmim",
      "uri" : "http://www.hl7.org/v3/PORX_RM020070UV",
      "name" : "V3 Pharmacy Dispense RMIM"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationDispense",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationDispense",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationDispense",
        "path" : "MedicationDispense",
        "short" : "Dispensation of prescribed medication to the patient",
        "definition" : "Ravimi väljastamine patsiendile."
      },
      {
        "id" : "MedicationDispense.contained",
        "path" : "MedicationDispense.contained",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.extension",
        "path" : "MedicationDispense.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "MedicationDispense.extension:extensionEETISBuyerEPC",
        "path" : "MedicationDispense.extension",
        "sliceName" : "extensionEETISBuyerEPC",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-buyer-epc"]
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension:extensionEETISBuyerEPC.value[x]",
        "path" : "MedicationDispense.extension.value[x]",
        "short" : "Personal identification code of the buyer",
        "definition" : "OSTJA ISIKUKOOD"
      },
      {
        "id" : "MedicationDispense.extension:extensionEETISReimbursementRate",
        "path" : "MedicationDispense.extension",
        "sliceName" : "extensionEETISReimbursementRate",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.extension:extensionEETISMedicationRemainder",
        "path" : "MedicationDispense.extension",
        "sliceName" : "extensionEETISMedicationRemainder",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.identifier",
        "path" : "MedicationDispense.identifier",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.basedOn",
        "path" : "MedicationDispense.basedOn",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.partOf",
        "path" : "MedicationDispense.partOf",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.status",
        "path" : "MedicationDispense.status",
        "short" : "When dispensation occurres it is always completed.",
        "definition" : "Ravimi väljamüük saab olla ainult \"completed\" staatuses, kui ravimit ei saa müüa siis muutub kas retsepti või ravimiskeemi rea staatus ja dispense pole üldse.",
        "fixedCode" : "completed"
      },
      {
        "id" : "MedicationDispense.notPerformedReason",
        "path" : "MedicationDispense.notPerformedReason",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.statusChanged",
        "path" : "MedicationDispense.statusChanged",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.category",
        "path" : "MedicationDispense.category",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.medication",
        "path" : "MedicationDispense.medication",
        "short" : "Dispensed medication",
        "definition" : "Väljastatud ravim",
        "type" : [
          {
            "code" : "CodeableReference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-dispensed-to-patient",
              "https://fhir.ee/StructureDefinition/ee-tis-medication-extemporal"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.subject",
        "path" : "MedicationDispense.subject",
        "short" : "Patient recieving the medication",
        "definition" : "Patsient, kellele ravim väljastatakse",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/mpi/StructureDefinition/ee-mpi-patient-verified"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.encounter",
        "path" : "MedicationDispense.encounter",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.supportingInformation",
        "path" : "MedicationDispense.supportingInformation",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.performer",
        "path" : "MedicationDispense.performer",
        "short" : "Indicates who or what performed the event.",
        "definition" : "Väljastuse teostaja ehk kes väljastas ravimi patsiendile. ",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationDispense.performer.function",
        "path" : "MedicationDispense.performer.function",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.performer.actor",
        "path" : "MedicationDispense.performer.actor",
        "short" : "Pharmacist or assistant pharmacist who has the rights to dispense meditcation.",
        "definition" : "Proviisor või farmatseut, kellel on õigus väljastada ravimit",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.location",
        "path" : "MedicationDispense.location",
        "short" : "The principal physical location where the dispense was performed.",
        "definition" : "APTEEK ja SELLE KOOD KUS RAVIM VÄLJASTATI.Apteegi tegevuskoha kood.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-pharmacy-location"
            ]
          }
        ]
      },
      {
        "id" : "MedicationDispense.location.identifier",
        "path" : "MedicationDispense.location.identifier",
        "definition" : "APTEEGI TEGEVUSKOHA KOOD. Logical reference, when literal reference is not known"
      },
      {
        "id" : "MedicationDispense.authorizingPrescription",
        "path" : "MedicationDispense.authorizingPrescription",
        "short" : "Retsept, mille alusel ravim väljastati patsiendile.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
          }
        ]
      },
      {
        "id" : "MedicationDispense.type",
        "path" : "MedicationDispense.type",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.quantity",
        "path" : "MedicationDispense.quantity",
        "short" : "The amount of medication that has been dispensed. Includes unit of measure.",
        "definition" : "Väljastatud ravimi kogus. Pakendite arv, mis väljastati. ",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.quantity.unit",
        "path" : "MedicationDispense.quantity.unit",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.quantity.system",
        "path" : "MedicationDispense.quantity.system",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.quantity.code",
        "path" : "MedicationDispense.quantity.code",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.daysSupply",
        "path" : "MedicationDispense.daysSupply",
        "short" : "Dispensed medication calculated in days. How many days is covered with this amount of medication.",
        "definition" : "müüdud kogus ümber arvutatud ravipäevadeks"
      },
      {
        "id" : "MedicationDispense.recorded",
        "path" : "MedicationDispense.recorded",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.whenPrepared",
        "path" : "MedicationDispense.whenPrepared",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.whenHandedOver",
        "path" : "MedicationDispense.whenHandedOver",
        "short" : "The time the dispensed product was provided to the patient or their representative.",
        "definition" : "Väljastamise aeg. Kuupäev ja kellaaeg, millal ravim anti üle patsiendile, või tema esindajale. ",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.destination",
        "path" : "MedicationDispense.destination",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.receiver",
        "path" : "MedicationDispense.receiver",
        "definition" : "KUI RAVIMI OSTAB VÄLJA KEEGI TEINE KUI SEE, KELLELE RAVIM ON VÄLJAKIRJUTATUD EI KASUTATA SEDA VAID ExtensionEETISBuyerEPC.",
        "max" : "1"
      },
      {
        "id" : "MedicationDispense.receiver.identifier.value",
        "path" : "MedicationDispense.receiver.identifier.value",
        "short" : "Buyers personal identification code. Logical reference, when literal reference is not known",
        "definition" : "OSTJA ISIKUKOOD",
        "min" : 1
      },
      {
        "id" : "MedicationDispense.note",
        "path" : "MedicationDispense.note",
        "short" : "Extra information about the dispense that could not be conveyed in the other attributes.",
        "definition" : "Kommentaar väljastuse kohta. Kommentaari saab lisada ainult see, kes teostas ravimi väljastuse apteegis. ",
        "max" : "1"
      },
      {
        "id" : "MedicationDispense.note.author[x]",
        "path" : "MedicationDispense.note.author[x]",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.renderedDosageInstruction",
        "path" : "MedicationDispense.renderedDosageInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction",
        "path" : "MedicationDispense.dosageInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.sequence",
        "path" : "MedicationDispense.dosageInstruction.sequence",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.additionalInstruction",
        "path" : "MedicationDispense.dosageInstruction.additionalInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.patientInstruction",
        "path" : "MedicationDispense.dosageInstruction.patientInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.timing",
        "path" : "MedicationDispense.dosageInstruction.timing",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.asNeeded",
        "path" : "MedicationDispense.dosageInstruction.asNeeded",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.asNeededFor",
        "path" : "MedicationDispense.dosageInstruction.asNeededFor",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.site",
        "path" : "MedicationDispense.dosageInstruction.site",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.route",
        "path" : "MedicationDispense.dosageInstruction.route",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.method",
        "path" : "MedicationDispense.dosageInstruction.method",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.doseAndRate",
        "path" : "MedicationDispense.dosageInstruction.doseAndRate",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.maxDosePerPeriod",
        "path" : "MedicationDispense.dosageInstruction.maxDosePerPeriod",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.maxDosePerAdministration",
        "path" : "MedicationDispense.dosageInstruction.maxDosePerAdministration",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.dosageInstruction.maxDosePerLifetime",
        "path" : "MedicationDispense.dosageInstruction.maxDosePerLifetime",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.substitution",
        "path" : "MedicationDispense.substitution",
        "max" : "0"
      },
      {
        "id" : "MedicationDispense.eventHistory",
        "path" : "MedicationDispense.eventHistory",
        "max" : "0"
      }
    ]
  }
}

```
