# ExtensionEETISPrescriptionChange - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISPrescriptionChange**

## Extension: ExtensionEETISPrescriptionChange 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-prescription-change | *Version*:1.0.0 |
| Draft as of 2024-09-06 | *Computable Name*:ExtensionEETISPrescriptionChange |

Retsepti muutmise aeg, muutja ja põhjus.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-prescription-change)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-prescription-change.csv), [Excel](StructureDefinition-ee-tis-prescription-change.xlsx), [Schematron](StructureDefinition-ee-tis-prescription-change.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-prescription-change",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-change",
  "version" : "1.0.0",
  "name" : "ExtensionEETISPrescriptionChange",
  "status" : "draft",
  "date" : "2024-09-06T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Retsepti muutmise aeg, muutja ja põhjus.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    },
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Changes on prescription - who changed, when and reason.",
        "definition" : "Retsepti muutmine, kes muutis, millal ja põhjus loendist."
      },
      {
        "id" : "Extension.extension:changeTime",
        "path" : "Extension.extension",
        "sliceName" : "changeTime",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:changeTime.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:changeTime.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "changeTime"
      },
      {
        "id" : "Extension.extension:changeTime.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Change time. Time when practitioner made the changes.",
        "definition" : "Muutmise aeg.",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Extension.extension:changeAuthor",
        "path" : "Extension.extension",
        "sliceName" : "changeAuthor",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:changeAuthor.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:changeAuthor.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "changeAuthor"
      },
      {
        "id" : "Extension.extension:changeAuthor.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Change author. The author who made the changes",
        "definition" : "Muutja.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role"
            ]
          }
        ]
      },
      {
        "id" : "Extension.extension:changeReason",
        "path" : "Extension.extension",
        "sliceName" : "changeReason",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:changeReason.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:changeReason.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "changeReason"
      },
      {
        "id" : "Extension.extension:changeReason.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Reason for changes. Code from Retseptikeskus ValueSet.",
        "definition" : "Muutmise põhjendus loendist.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "description" : "\"Muutmise põhjendus\"-loend retseptikeskusest"
        }
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-prescription-change"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
