# EETISPractitionerRole - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISPractitionerRole**

## Resource Profile: EETISPractitionerRole 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-practitioner-role | *Version*:1.0.0 |
| Draft as of 2024-01-16 | *Computable Name*:EETISPractitionerRole |

 
Tervishoiutöötaja roll. Certified/licenced practitioner in a certain role in specified organization. E.g doctors working in different places may have different obligations/rights depending on the role they have in that organization. 

**Usages:**

* Refer to this Profile: [EETISAnnotation](StructureDefinition-ee-tis-annotation.md), [EETISCommunication](StructureDefinition-ee-tis-communication.md), [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md), [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)...Show 5 more,[EETISObservationEGFR](StructureDefinition-ee-tis-observation-egfr.md),[ExtensionEETISPrescriptionChange](StructureDefinition-ee-tis-prescription-change.md),[EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md),[EETISPrescription](StructureDefinition-ee-tis-prescription.md)and[ExtensionEETISVerification](StructureDefinition-ee-tis-verification.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-practitioner-role)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-practitioner-role.csv), [Excel](StructureDefinition-ee-tis-practitioner-role.xlsx), [Schematron](StructureDefinition-ee-tis-practitioner-role.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-practitioner-role",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role",
  "version" : "1.0.0",
  "name" : "EETISPractitionerRole",
  "status" : "draft",
  "date" : "2024-01-16T07:51:36.859751+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Tervishoiutöötaja roll. Certified/licenced practitioner in a certain role in specified organization. E.g doctors working in different places may have different obligations/rights depending on the role they have in that organization.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    },
    {
      "identity" : "servd",
      "uri" : "http://www.omg.org/spec/ServD/1.0/",
      "name" : "ServD"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "PractitionerRole",
  "baseDefinition" : "https://fhir.ee/base/StructureDefinition/ee-practitioner-role",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "PractitionerRole",
        "path" : "PractitionerRole"
      },
      {
        "id" : "PractitionerRole.code",
        "path" : "PractitionerRole.code",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/autoriseerimismooduli-kasutajarollid"
        }
      }
    ]
  }
}

```
