# EETISPharmacyLocation - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISPharmacyLocation**

## Resource Profile: EETISPharmacyLocation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-pharmacy-location | *Version*:1.0.0 |
| Draft as of 2023-09-28 | *Computable Name*:EETISPharmacyLocation |

 
Apteegi asukoht. This resource is used when there is a need to specify a certain pharmacy for medication dispensation. 

**Usages:**

* Refer to this Profile: [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)
* Examples for this Profile: [Tehiku apteek](Location-tehiku-apteek.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-pharmacy-location)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-pharmacy-location.csv), [Excel](StructureDefinition-ee-tis-pharmacy-location.xlsx), [Schematron](StructureDefinition-ee-tis-pharmacy-location.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-pharmacy-location",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-pharmacy-location",
  "version" : "1.0.0",
  "name" : "EETISPharmacyLocation",
  "status" : "draft",
  "date" : "2023-09-28T10:15:30.0319461+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Apteegi asukoht. This resource is used when there is a need to specify a certain pharmacy for medication dispensation.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "interface",
      "uri" : "http://hl7.org/fhir/interface",
      "name" : "Interface Pattern"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Location",
  "baseDefinition" : "https://fhir.ee/base/StructureDefinition/ee-location",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Location",
        "path" : "Location"
      },
      {
        "id" : "Location.contained",
        "path" : "Location.contained",
        "max" : "0"
      },
      {
        "id" : "Location.identifier",
        "path" : "Location.identifier",
        "definition" : "APTEEGI TEGEVUSKOHA KOOD."
      },
      {
        "id" : "Location.operationalStatus",
        "path" : "Location.operationalStatus",
        "max" : "0"
      },
      {
        "id" : "Location.name",
        "path" : "Location.name",
        "definition" : "APTEEGI TEGEVUSKOHA NIMI."
      },
      {
        "id" : "Location.type",
        "path" : "Location.type",
        "max" : "0"
      },
      {
        "id" : "Location.position",
        "path" : "Location.position",
        "max" : "0"
      },
      {
        "id" : "Location.managingOrganization",
        "path" : "Location.managingOrganization",
        "definition" : "APTEEGI ÄRIREGISTRI KOOD."
      },
      {
        "id" : "Location.partOf",
        "path" : "Location.partOf",
        "max" : "0"
      },
      {
        "id" : "Location.characteristic",
        "path" : "Location.characteristic",
        "max" : "0"
      },
      {
        "id" : "Location.hoursOfOperation",
        "path" : "Location.hoursOfOperation",
        "max" : "0"
      },
      {
        "id" : "Location.virtualService",
        "path" : "Location.virtualService",
        "max" : "0"
      },
      {
        "id" : "Location.endpoint",
        "path" : "Location.endpoint",
        "max" : "0"
      }
    ]
  }
}

```
