# ExtensionEETISMedicinalProductName - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISMedicinalProductName**

## Extension: ExtensionEETISMedicinalProductName 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name | *Version*:1.0.0 |
| Draft as of 2023-10-03 | *Computable Name*:ExtensionEETISMedicinalProductName |

Ravimi nimi. Registered name for the medicinal product.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationDispensedToPatient](StructureDefinition-ee-tis-medication-dispensed-to-patient.md), [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md) and [EETISMedicationRenalFunction](StructureDefinition-ee-tis-medication-renal-function.md)
* Examples for this Extension: [Medication/adrenalin](Medication-adrenalin.md), [Medication/adrenaline-renal-function](Medication-adrenaline-renal-function.md), [Medication/alprazolam-dispensed](Medication-alprazolam-dispensed.md), [Medication/alprazolam](Medication-alprazolam.md)...Show 5 more,[Medication/aspirin](Medication-aspirin.md),[Medication/dexamethason](Medication-dexamethason.md),[Medication/fenoksymetyylpenitsilliin](Medication-fenoksymetyylpenitsilliin.md),[Medication/metformin-dispensed](Medication-metformin-dispensed.md)and[Medication/novorapid](Medication-novorapid.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medicinal-product-name)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medicinal-product-name.csv), [Excel](StructureDefinition-ee-tis-medicinal-product-name.xlsx), [Schematron](StructureDefinition-ee-tis-medicinal-product-name.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medicinal-product-name",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name",
  "version" : "1.0.0",
  "name" : "ExtensionEETISMedicinalProductName",
  "status" : "draft",
  "date" : "2023-10-03T10:47:00.9373224+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimi nimi. Registered name for the medicinal product.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Medication"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Registered name for the medicinal product.",
        "definition" : "Ravimi nimi pakendil. Näiteks 'Betaloc ZOC' või 'Sudafed' jne"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          }
        ],
        "maxLength" : 500
      }
    ]
  }
}

```
