# ExtensionEETISMedicationRemainder - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISMedicationRemainder**

## Extension: ExtensionEETISMedicationRemainder 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-remainder | *Version*:1.0.0 |
| Draft as of 2023-10-03 | *Computable Name*:ExtensionEETISMedicationRemainder |

Jääk. Extension describing how many days worth medication is left on prescription.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)
* Examples for this Extension: [MedicationDispense/dispensation-metformin](MedicationDispense-dispensation-metformin.md), [MedicationStatement/MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md), [MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md), [MedicationStatement/MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md)...Show 2 more,[MedicationStatement/MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md)and[MedicationStatement/MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-remainder)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-remainder.csv), [Excel](StructureDefinition-ee-tis-medication-remainder.xlsx), [Schematron](StructureDefinition-ee-tis-medication-remainder.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-remainder",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder",
  "version" : "1.0.0",
  "name" : "ExtensionEETISMedicationRemainder",
  "status" : "draft",
  "date" : "2023-10-03T10:47:00.9373224+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Jääk. Extension describing how many days worth medication is left on prescription.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    },
    {
      "type" : "element",
      "expression" : "MedicationDispense"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Medication left on prescription calculated in days.",
        "definition" : "Arvutuslik ravimi jääk päevades."
      },
      {
        "id" : "Extension.extension:daysAvailable",
        "path" : "Extension.extension",
        "sliceName" : "daysAvailable",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:daysAvailable.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:daysAvailable.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "daysAvailable"
      },
      {
        "id" : "Extension.extension:daysAvailable.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "How much medication calculated in days is on MedicationStatement initially before dispense. Value is to be calculated. Number of medication available changes after every dispensation.",
        "definition" : "Ravimi algne seis ravimiskeemi real enne väljamüüki. Väärtus kuvatakse päevades. Arvutatakse taustal. Päevade arv muutub peale iga väljamüüki.",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Extension.extension:daysDispensed",
        "path" : "Extension.extension",
        "sliceName" : "daysDispensed",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:daysDispensed.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:daysDispensed.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "daysDispensed"
      },
      {
        "id" : "Extension.extension:daysDispensed.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "How many days of medication is dispensed. Value is to be calculated. Value in days.",
        "definition" : "Väljamüüdud ravimi kogus päevades.",
        "type" : [
          {
            "code" : "integer"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
