# EETISMedicationExtemporal - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationExtemporal**

## Resource Profile: EETISMedicationExtemporal 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-extemporal | *Version*:1.0.0 |
| Draft as of 2024-07-08 | *Computable Name*:EETISMedicationExtemporal |

 
Ekstemporaalne ravim. Profile for representing medication that is prepared in pharmacy by pharmacist. E.g. sulfur ointment or solution of Protargoli. 

**Usages:**

* Refer to this Profile: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md), [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* Examples for this Profile: [Medication/extemporal](Medication-extemporal.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-extemporal)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-extemporal.csv), [Excel](StructureDefinition-ee-tis-medication-extemporal.xlsx), [Schematron](StructureDefinition-ee-tis-medication-extemporal.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-extemporal",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-extemporal",
  "version" : "1.0.0",
  "name" : "EETISMedicationExtemporal",
  "status" : "draft",
  "date" : "2024-07-08T14:34:42.5909877+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ekstemporaalne ravim. Profile for representing medication that is prepared in pharmacy by pharmacist. E.g. sulfur ointment or solution of Protargoli.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.meta.versionId",
        "path" : "Medication.meta.versionId",
        "example" : [
          {
            "label" : "versionId",
            "valueId" : "1"
          }
        ]
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "short" : "Prescription number",
        "definition" : "Retsepti number",
        "max" : "1"
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "max" : "0"
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "max" : "0"
      },
      {
        "id" : "Medication.marketingAuthorizationHolder",
        "path" : "Medication.marketingAuthorizationHolder",
        "max" : "0"
      },
      {
        "id" : "Medication.doseForm",
        "path" : "Medication.doseForm",
        "short" : "Dose form of the medication. E.g powder, tablet, ointment etc.",
        "definition" : "Väljakirjutatud ravimi ravimvorm (loendist). Nt. pulber, tablett, salv jne",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/ravimvormid"
        }
      },
      {
        "id" : "Medication.totalVolume",
        "path" : "Medication.totalVolume",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "Medication.totalVolume.value",
        "path" : "Medication.totalVolume.value",
        "short" : "Total volume of medication.",
        "definition" : "Ühikute koguhulk. Ainult number, nt 100",
        "min" : 1
      },
      {
        "id" : "Medication.totalVolume.unit",
        "path" : "Medication.totalVolume.unit",
        "max" : "0"
      },
      {
        "id" : "Medication.totalVolume.code",
        "path" : "Medication.totalVolume.code",
        "short" : "Unit for total volume",
        "definition" : "Ühikute koguhulga ühik"
      },
      {
        "id" : "Medication.ingredient",
        "path" : "Medication.ingredient",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.item",
        "path" : "Medication.ingredient.item",
        "short" : "List of ingredients in precise amounts for medication preparation",
        "definition" : "Retsept koos vajalike kogustega ravimi valmistamiseks apteegis"
      },
      {
        "id" : "Medication.ingredient.item.concept.text",
        "path" : "Medication.ingredient.item.concept.text",
        "min" : 1
      },
      {
        "id" : "Medication.batch",
        "path" : "Medication.batch",
        "max" : "0"
      },
      {
        "id" : "Medication.definition",
        "path" : "Medication.definition",
        "max" : "0"
      }
    ]
  }
}

```
