# ExtensionEETISLockStatus - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISLockStatus**

## Extension: ExtensionEETISLockStatus 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-lock-status | *Version*:1.0.0 |
| Draft as of 2023-12-05 | *Computable Name*:ExtensionEETISLockStatus |

Broneering retseptil. When pharmacy locks the prescription for ordering unauthorized medication for patient.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* Examples for this Extension: [MedicationRequest/prescription-adrenalin-pos-dec](MedicationRequest-prescription-adrenalin-pos-dec.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-lock-status)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-lock-status.csv), [Excel](StructureDefinition-ee-tis-lock-status.xlsx), [Schematron](StructureDefinition-ee-tis-lock-status.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-lock-status",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-lock-status",
  "version" : "1.0.0",
  "name" : "ExtensionEETISLockStatus",
  "status" : "draft",
  "date" : "2023-12-05T08:56:43.9409623+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Broneering retseptil. When pharmacy locks the prescription for ordering unauthorized medication for patient.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    },
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Lock on prescription and pharmacy who locked",
        "definition" : "Broneering retseptil. When pharmacy locks the prescription for ordering unauthorized medication for patient."
      },
      {
        "id" : "Extension.extension:lockStatus",
        "path" : "Extension.extension",
        "sliceName" : "lockStatus",
        "short" : "Prescription is locked in pharmacy",
        "definition" : "Broneeritud apteegis. Kasutatakse juhul kui on tegemist müügiloata ravimi retseptiga, mis on saanud positiivse otsuse ning ootab apteegis tellitavat ravimit. ",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:lockStatus.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:lockStatus.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "lockStatus"
      },
      {
        "id" : "Extension.extension:lockStatus.value[x]",
        "path" : "Extension.extension.value[x]",
        "definition" : "True - prescription is locked for certain pharmacy.\r\nFalse - prescription is not locked.",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Extension.extension:lockOwner",
        "path" : "Extension.extension",
        "sliceName" : "lockOwner",
        "short" : "Pharmacy who locked the prescription for ordering unauthorized medication.",
        "definition" : "Broneeringu teinud apteek",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:lockOwner.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:lockOwner.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "lockOwner"
      },
      {
        "id" : "Extension.extension:lockOwner.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-lock-status"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
