# ExtensionEETISDispensationAuthorization - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISDispensationAuthorization**

## Extension: ExtensionEETISDispensationAuthorization 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization | *Version*:1.0.0 |
| Draft as of 2024-02-21 | *Computable Name*:ExtensionEETISDispensationAuthorization |

Volituse liik. Defines the authorization of the prescription.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* Examples for this Extension: [MedicationRequest/prescription-adrenalin-pos-dec](MedicationRequest-prescription-adrenalin-pos-dec.md), [MedicationRequest/prescription-alprazolam](MedicationRequest-prescription-alprazolam.md), [MedicationRequest/prescription-cancelled](MedicationRequest-prescription-cancelled.md), [MedicationRequest/prescription-metformin](MedicationRequest-prescription-metformin.md)...Show 5 more,[MedicationStatement/MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md),[MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md),[MedicationStatement/MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md),[MedicationStatement/MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md)and[MedicationStatement/MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-dispensation-authorization)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-dispensation-authorization.csv), [Excel](StructureDefinition-ee-tis-dispensation-authorization.xlsx), [Schematron](StructureDefinition-ee-tis-dispensation-authorization.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-dispensation-authorization",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
  "version" : "1.0.0",
  "name" : "ExtensionEETISDispensationAuthorization",
  "status" : "draft",
  "date" : "2024-02-21T12:23:02.5700529+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Volituse liik. Defines the authorization of the prescription.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    },
    {
      "type" : "element",
      "expression" : "MedicationRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Defines the authorization of the prescription.",
        "definition" : "Volituse liik. Digiretsepti koostamisel on patsiendil võimalik piirata ravimi väljaostu õiguseid. Vaikimisi on küll kõik retseptid avalikud, kuid seda staatust saab muuta arst retsepti koostamisel või patsient terviseportaalis."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Prescription can be public, private or authorized.\r\n\r\navalik | privaatne | volitatud",
        "definition" : "Volituse liik",
        "min" : 1,
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-volituse-liik"
        }
      }
    ]
  }
}

```
