# ExtensionEETISBuyerEPC - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISBuyerEPC**

## Extension: ExtensionEETISBuyerEPC 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-buyer-epc | *Version*:1.0.0 |
| Draft as of 2023-10-03 | *Computable Name*:ExtensionEETISBuyerEPC |

Ostja. When someone other than the subject of prescription buys medication.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)
* Examples for this Extension: [MedicationDispense/dispensation-metformin](MedicationDispense-dispensation-metformin.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-buyer-epc)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-buyer-epc.csv), [Excel](StructureDefinition-ee-tis-buyer-epc.xlsx), [Schematron](StructureDefinition-ee-tis-buyer-epc.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-buyer-epc",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-buyer-epc",
  "version" : "1.0.0",
  "name" : "ExtensionEETISBuyerEPC",
  "status" : "draft",
  "date" : "2023-10-03T10:47:00.9373224+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ostja. When someone other than the subject of prescription buys medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationDispense"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Identity code of the buyer of medicine when the buyer is someone else than the subject of prescription.",
        "definition" : "Ostja. Keegi teine kui see, kellele ravim välja kirjutati."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-buyer-epc"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Buyer's identity code",
        "definition" : "Ravimit välja ostva isiku isikukood.",
        "min" : 1,
        "type" : [
          {
            "code" : "string"
          },
          {
            "code" : "Identifier"
          }
        ]
      }
    ]
  }
}

```
