# EETISAnnotation - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISAnnotation**

## Data Type Profile: EETISAnnotation 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-annotation | *Version*:1.0.0 |
| Draft as of 2024-01-31 | *Computable Name*:EETISAnnotation |

 
Kommentaar/märkus. Note or comment with time and author. 

**Usages:**

* Use this DataType Profile: [EETISCommunication](StructureDefinition-ee-tis-communication.md) and [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-annotation)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-annotation.csv), [Excel](StructureDefinition-ee-tis-annotation.xlsx), [Schematron](StructureDefinition-ee-tis-annotation.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-annotation",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "has-size"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-annotation",
  "version" : "1.0.0",
  "name" : "EETISAnnotation",
  "status" : "draft",
  "date" : "2024-01-31T13:55:03.1985103+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Kommentaar/märkus. Note or comment with time and author.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Annotation",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Annotation",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Annotation",
        "path" : "Annotation",
        "short" : "Note/comment",
        "definition" : "Kommentaar/märkus.Kommentaar terve ravimiskeemi kohta. Erineb ravimiskeemi üksiku rea kommentaarist, vt. Communication-profiili."
      },
      {
        "id" : "Annotation.author[x]",
        "path" : "Annotation.author[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Healthcare professional who added comment. Use string to express the name and role of HCP"
      },
      {
        "id" : "Annotation.author[x]:authorReference",
        "path" : "Annotation.author[x]",
        "sliceName" : "authorReference",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/base/StructureDefinition/ee-practitioner",
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role",
              "https://fhir.ee/base/StructureDefinition/ee-organization"
            ]
          }
        ]
      },
      {
        "id" : "Annotation.author[x]:authorString",
        "path" : "Annotation.author[x]",
        "sliceName" : "authorString",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Annotation.time",
        "path" : "Annotation.time",
        "short" : "Time when the comment was added.",
        "definition" : "Kommentaari lisamise aeg"
      },
      {
        "id" : "Annotation.text",
        "path" : "Annotation.text",
        "short" : "Comment about medication scheme",
        "definition" : "Kommentaari sisu"
      }
    ]
  }
}

```
