# PractRoleD12345 - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractRoleD12345**

## Example PractitionerRole: PractRoleD12345

Language: et

Profile: [EEBase PractitionerRole](https://fhir.ee/packages/ee-base/2.0.0/site/StructureDefinition-ee-practitioner-role.html)

**active**: true

**period**: 2012-01-01 --> (ongoing)

**practitioner**: [Practitioner Mart Murakas](Practitioner-D12345.md)

**organization**: [Organization Rakvere Haigla](Organization-rh.md)

**code**: Doctor, Pediaater

**specialty**: Pediaatria, Pediaatria allergoloogia lisapädevusega



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "PractRoleD12345",
  "meta" : {
    "profile" : [
      "https://fhir.ee/base/StructureDefinition/ee-practitioner-role"
    ]
  },
  "language" : "et",
  "active" : true,
  "period" : {
    "start" : "2012-01-01"
  },
  "practitioner" : {
    "reference" : "Practitioner/D12345"
  },
  "organization" : {
    "reference" : "Organization/rh"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/practitioner-role",
          "code" : "doctor",
          "display" : "Doctor"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ee-occupation",
          "code" : "22122501",
          "display" : "Pediaater"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ee-medre-specialty",
          "code" : "E290",
          "display" : "Pediaatria"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ee-medre-specialty",
          "code" : "E670",
          "display" : "Pediaatria allergoloogia lisapädevusega"
        }
      ]
    }
  ]
}

```
