# N98765 - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **N98765**

## Example Practitioner: N98765

Language: et

Profile: [EEBase Practitioner](https://fhir.ee/packages/ee-base/2.0.0/site/StructureDefinition-ee-practitioner.html)

**identifier**: `https://fhir.ee/sid/pro/est/pho`/N98765, `https://fhir.ee/sid/pid/est/ni`/49806307018

**active**: true

**name**: Laura Õde 

### Qualifications

| | |
| :--- | :--- |
| - | **Code** |
| * | Advanced Practice Nurse |



## Resource Content

```json
{
  "resourceType" : "Practitioner",
  "id" : "N98765",
  "meta" : {
    "profile" : ["https://fhir.ee/base/StructureDefinition/ee-practitioner"]
  },
  "language" : "et",
  "identifier" : [
    {
      "system" : "https://fhir.ee/sid/pro/est/pho",
      "value" : "N98765"
    },
    {
      "system" : "https://fhir.ee/sid/pid/est/ni",
      "value" : "49806307018"
    }
  ],
  "active" : true,
  "name" : [
    {
      "family" : "Õde",
      "given" : ["Laura"]
    }
  ],
  "qualification" : [
    {
      "code" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/v2-0360",
            "code" : "PN",
            "display" : "Advanced Practice Nurse"
          }
        ]
      }
    }
  ]
}

```
