# Get history of medication statements - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Get history of medication statements**

## OperationDefinition: Get history of medication statements 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.ee/OperationDefinition/MedicationStatement-history | *Version*:1.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Confirmed medications history |

 
Returns the history of the current MedicationPlan(confirmed MedicationStatements) for requested patient 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "MedicationStatement-history",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://fhir.ee/OperationDefinition/MedicationStatement-history",
  "version" : "1.0.0",
  "name" : "Confirmed medications history",
  "title" : "Get history of medication statements",
  "status" : "active",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2024-07-09T00:00:00Z",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Returns the history of the current MedicationPlan(confirmed MedicationStatements) for requested patient",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "history",
  "resource" : ["MedicationStatement"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Patient",
      "type" : "Patient"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "In force medication plan, i.e. the interconnected List, MedicationStatement and Medication resources",
      "type" : "Bundle"
    }
  ]
}

```
