# Medication Statement Confirm - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Medication Statement Confirm**

## OperationDefinition: Medication Statement Confirm 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.ee/OperationDefinition/MedicationStatement-confirm | *Version*:1.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Confirm |

 
The $confirm operation manages a medication plan of a patient, i.e. creates a snapshot of effective medication statements as well as propagates medication requests. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "MedicationStatement-confirm",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://fhir.ee/OperationDefinition/MedicationStatement-confirm",
  "version" : "1.0.0",
  "name" : "Confirm",
  "title" : "Medication Statement Confirm",
  "status" : "active",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2024-02-29T15:21:02+11:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The $confirm operation manages a medication plan of a patient, i.e. creates a snapshot of effective medication statements as well as propagates medication requests.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "affectsState" : true,
  "code" : "confirm",
  "resource" : ["MedicationStatement"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "lastKnownConfirmation",
      "use" : "in",
      "min" : 0,
      "max" : "1",
      "documentation" : "Fully qualified reference to the previous medication plan (i.e. List resource)",
      "type" : "Reference"
    },
    {
      "name" : "input",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Added, changed and ceased medication statements and the included medication resources as they should be persisted in the next snapshot of the medication plan",
      "type" : "Bundle"
    },
    {
      "name" : "confirmer",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "The PractitionerRole resource of the practitioner confirming the statements, will be added to prescribed statements and list resource as contained resource",
      "type" : "PractitionerRole"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "In force medication plan, i.e. the interconnected List, MedicationStatement and Medication resources",
      "type" : "Bundle"
    }
  ]
}

```
