# Find renal failure warnings for medications - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Find renal failure warnings for medications**

## OperationDefinition: Find renal failure warnings for medications 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.ee/OperationDefinition/Medication-renal-failure-warnings | *Version*:1.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Renal Failure Warnings |

 
The renal failure warnings operation is used to get renal warnings for given Medications or Medication Scheme. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Medication-renal-failure-warnings",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://fhir.ee/OperationDefinition/Medication-renal-failure-warnings",
  "version" : "1.0.0",
  "name" : "Renal Failure Warnings",
  "title" : "Find renal failure warnings for medications",
  "status" : "active",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2025-07-11T00:00:00Z",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The renal failure warnings operation is used to get renal warnings for given Medications or Medication Scheme.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "renal-failure-warnings",
  "resource" : ["Medication"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "subject",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Reference",
      "type" : "Reference"
    },
    {
      "name" : "input",
      "use" : "in",
      "min" : 0,
      "max" : "*",
      "documentation" : "List of new medications. If not empty then only warnings between input medications will be returned. Old medication warnings won't be returned.",
      "type" : "Medication"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Found warnings",
      "type" : "ClinicalUseDefinition"
    }
  ]
}

```
