# prescription-cancelled - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **prescription-cancelled**

## Example MedicationRequest: prescription-cancelled

Language: et

Profile: [EETISPrescription](StructureDefinition-ee-tis-prescription.md)

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 50%
* reimbursementCondition: vajalikud tingimused bla bla
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISDispensationAuthorization**: Avalik

**identifier**: `https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept`/1018862058

**status**: Cancelled

**statusReason**: Raviskeemi muudatus: soovimatu koos- või kõrvaltoime

**statusChanged**: 2014-06-10

**intent**: Order

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = fenoksümetüülpenitsilliin,Ospen; identifier = http://ravimiregister.ee/pakendid#123456; doseForm = õhukese polümeerikattega tablett; totalVolume = 12](Medication-fenoksymetyylpenitsilliin.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**informationSource**: [PractitionerRole Doctor](PractitionerRole-PractRoleD12345.md)

**authoredOn**: 2023-11-07

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Streptokokitekkene äge bronhiit |

> **dosageInstruction****timing**: Count 3 times, Once per 8 hours

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 tablett(Details: ER_Ühikud annustamine codeTA = 'tablet(s)') |


### DispenseRequests

| | |
| :--- | :--- |
| - | **ValidityPeriod** |
| * | 2023-11-07 --> 2024-05-07 |

### Substitutions

| | | |
| :--- | :--- | :--- |
| - | **Allowed[x]** | **Reason** |
| * | false | tegemist on bioloogilise ravimiga |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "prescription-cancelled",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "050",
                "display" : "50%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "90_1",
                "display" : "vajalikud tingimused bla bla"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/retsepti-volituse-liik",
            "code" : "public",
            "display" : "Avalik"
          }
        ]
      }
    }
  ],
  "identifier" : [
    {
      "system" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept",
      "value" : "1018862058"
    }
  ],
  "status" : "cancelled",
  "statusReason" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/retsepti-annulleerimise-pohjus",
        "code" : "AN01",
        "display" : "Raviskeemi muudatus: soovimatu koos- või kõrvaltoime"
      }
    ]
  },
  "statusChanged" : "2014-06-10",
  "intent" : "order",
  "medication" : {
    "reference" : {
      "reference" : "Medication/fenoksymetyylpenitsilliin"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "informationSource" : [
    {
      "reference" : "PractitionerRole/PractRoleD12345"
    }
  ],
  "authoredOn" : "2023-11-07",
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/rhk10",
            "code" : "J20.2",
            "display" : "Streptokokitekkene äge bronhiit"
          }
        ]
      }
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "count" : 3,
          "durationUnit" : "d",
          "frequency" : 1,
          "period" : 8,
          "periodUnit" : "h"
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "tablett",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "TA"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2023-11-07",
      "end" : "2024-05-07"
    }
  },
  "substitution" : {
    "allowedBoolean" : false,
    "reason" : {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ravimi-asendamatuse-pohjus",
          "code" : "KP01",
          "display" : "tegemist on bioloogilise ravimiga"
        }
      ]
    }
  }
}

```
