# prescription-adrenalin-pos-dec - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **prescription-adrenalin-pos-dec**

## Example MedicationRequest: prescription-adrenalin-pos-dec

Language: et

Profile: [EETISPrescription](StructureDefinition-ee-tis-prescription.md)

> **ExtensionEETISReimbursementRate**
* reimbursementRate: 0%
* reimbursementCondition: vajalikud tingimused bla bla
* reimbursementSpeciality: dermatoveneroloogia

**ExtensionEETISDispensationAuthorization**: Avalik

> **ExtensionEETISLockStatus**
* lockStatus: true
* lockOwner: Tehiku Apteek

> **ExtensionEETISUnauthorizedProductRequest**
* requestNumber: 123456
* requestReason: Eestis puudub haiguse/seisundi raviks müügiloaga ravim
* requestStatus: Otsus positiivne
* requestDate: 2023-11-11

**identifier**: `https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept`/1018862058

**status**: Active

**statusChanged**: 2023-11-07

**intent**: Proposal

**category**: Tavaretsept, 1-kordne

### Medications

| | |
| :--- | :--- |
| - | **Reference** |
| * | [Medication: extension = epinefriin,1 ML,Adrenaliin; identifier = http://ravimiregister.ee/pakendid#123456; doseForm = süstelahus; totalVolume = 5](Medication-adrenalin.md) |

**subject**: [Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)](Patient-pat1MatiMeri.md)

**authoredOn**: 2023-11-07

### Reasons

| | |
| :--- | :--- |
| - | **Concept** |
| * | Immuunmehhanismi hõlmavad mujal klassifitseerimata muud täpsustatud haigusseisundid |

> **dosageInstruction****timing**: Count 1 times, Once

### DoseAndRates

| | |
| :--- | :--- |
| - | **Dose[x]** |
| * | 1 milliliiter(Details: retsept-annustamise-yhik codeML = 'milliliter(s)') |


### DispenseRequests

| | |
| :--- | :--- |
| - | **ValidityPeriod** |
| * | 2023-11-07 --> 2024-02-07 |



## Resource Content

```json
{
  "resourceType" : "MedicationRequest",
  "id" : "prescription-adrenalin-pos-dec",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"]
  },
  "language" : "et",
  "extension" : [
    {
      "extension" : [
        {
          "url" : "reimbursementRate",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/retsepti-soodustuse-maar",
                "code" : "000",
                "display" : "0%"
              }
            ]
          }
        },
        {
          "url" : "reimbursementCondition",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/ravimi-soodustuse-vajalikud-tingimused",
                "code" : "90_1",
                "display" : "vajalikud tingimused bla bla"
              }
            ]
          }
        },
        {
          "url" : "reimbursementSpeciality",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/erialad",
                "code" : "E110",
                "display" : "dermatoveneroloogia"
              }
            ]
          }
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/retsepti-volituse-liik",
            "code" : "public",
            "display" : "Avalik"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "lockStatus",
          "valueBoolean" : true
        },
        {
          "url" : "lockOwner",
          "valueString" : "Tehiku Apteek"
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-lock-status"
    },
    {
      "extension" : [
        {
          "url" : "requestNumber",
          "valueId" : "123456"
        },
        {
          "url" : "requestReason",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/myygiloata-ravimi-pohjendus",
                "code" : "ML01",
                "display" : "Eestis puudub haiguse/seisundi raviks müügiloaga ravim"
              }
            ]
          }
        },
        {
          "url" : "requestStatus",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "https://fhir.ee/CodeSystem/myygiloata-ravimi-taotluse-otsus",
                "code" : "P",
                "display" : "Otsus positiivne"
              }
            ]
          }
        },
        {
          "url" : "requestDate",
          "valueDateTime" : "2023-11-11"
        }
      ],
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-unauthorized-product-request"
    }
  ],
  "identifier" : [
    {
      "system" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept",
      "value" : "1018862058"
    }
  ],
  "status" : "active",
  "statusChanged" : "2023-11-07",
  "intent" : "proposal",
  "category" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-liik",
          "code" : "1",
          "display" : "Tavaretsept"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/retsepti-kordsus",
          "code" : "1",
          "display" : "1-kordne"
        }
      ]
    }
  ],
  "medication" : {
    "reference" : {
      "reference" : "Medication/adrenalin"
    }
  },
  "subject" : {
    "reference" : "Patient/pat1MatiMeri"
  },
  "authoredOn" : "2023-11-07",
  "reason" : [
    {
      "concept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/rhk10",
            "code" : "D89.8",
            "display" : "Immuunmehhanismi hõlmavad mujal klassifitseerimata muud täpsustatud haigusseisundid"
          }
        ]
      }
    }
  ],
  "dosageInstruction" : [
    {
      "timing" : {
        "repeat" : {
          "count" : 1
        }
      },
      "doseAndRate" : [
        {
          "doseQuantity" : {
            "value" : 1,
            "unit" : "milliliiter",
            "system" : "https://fhir.ee/CodeSystem/retsept-annustamise-yhik",
            "code" : "ML"
          }
        }
      ]
    }
  ],
  "dispenseRequest" : {
    "validityPeriod" : {
      "start" : "2023-11-07",
      "end" : "2024-02-07"
    }
  }
}

```
