# aspirin - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **aspirin**

## Example Medication: aspirin

Language: et

Profile: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)

**ExtensionEETISMedicinalProductClassification**: Atsetüülsalitsüülhape

**ExtensionEETISMedicinalProductName**: ASPIRIN CARDIO

**identifier**: `http://ravimiregister.ee/pakendid`/1345687

**doseForm**: gastroresistentne tablett

**totalVolume**: 98

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | atsetüülsalitsüülhape |

**isActive**: true**strength**: 1(unit MG from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeMG = 'milligram(s)')/1(unit TABL from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeTABL = 'tablet(s)')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "aspirin",
  "meta" : {
    "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-medication-epc"]
  },
  "language" : "et",
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/atc-ee",
            "code" : "B01AC06",
            "display" : "Atsetüülsalitsüülhape"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name",
      "valueString" : "ASPIRIN CARDIO"
    }
  ],
  "identifier" : [
    {
      "system" : "http://ravimiregister.ee/pakendid",
      "value" : "1345687"
    }
  ],
  "doseForm" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravimvormid",
        "code" : "965",
        "display" : "gastroresistentne tablett"
      }
    ]
  },
  "totalVolume" : {
    "value" : 98
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "https://fhir.ee/CodeSystem/toimeained",
              "code" : "9773",
              "display" : "atsetüülsalitsüülhape"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "MG"
        },
        "denominator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "TABL"
        }
      }
    }
  ]
}

```
