# adrenaline-renal-function - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **adrenaline-renal-function**

## Example Medication: adrenaline-renal-function

Language: et

Profile: [EETISMedicationRenalFunction](StructureDefinition-ee-tis-medication-renal-function.md)

**ExtensionEETISMedicinalProductClassification**: epinefriin

**ExtensionEETISMedicinalProductName**: Adrenaline auxilia

**identifier**: `http://ravimiregister.ee/pakendid`/3018563

**doseForm**: süstelahus

> **ingredient**

### Items

| | |
| :--- | :--- |
| - | **Concept** |
| * | epinefriin |

**isActive**: true**strength**: 1(unit MG from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeMG = 'milligram(s)')/1(unit ML from https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik)(Details: ER_Ühikud mahu- ja massiühikud codeML = 'milliliter(s)')



## Resource Content

```json
{
  "resourceType" : "Medication",
  "id" : "adrenaline-renal-function",
  "meta" : {
    "profile" : [
      "https://fhir.ee/StructureDefinition/ee-tis-medication-renal-function"
    ]
  },
  "language" : "et",
  "extension" : [
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://fhir.ee/CodeSystem/atc-ee",
            "code" : "C01CA24",
            "display" : "epinefriin"
          }
        ]
      }
    },
    {
      "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name",
      "valueString" : "Adrenaline auxilia"
    }
  ],
  "identifier" : [
    {
      "system" : "http://ravimiregister.ee/pakendid",
      "value" : "3018563"
    }
  ],
  "doseForm" : {
    "coding" : [
      {
        "system" : "https://fhir.ee/CodeSystem/ravimvormid",
        "code" : "739",
        "display" : "süstelahus"
      }
    ]
  },
  "ingredient" : [
    {
      "item" : {
        "concept" : {
          "coding" : [
            {
              "system" : "https://fhir.ee/CodeSystem/toimeained",
              "code" : "8554",
              "display" : "epinefriin"
            }
          ]
        }
      },
      "isActive" : true,
      "strengthRatio" : {
        "numerator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "MG"
        },
        "denominator" : {
          "value" : 1,
          "system" : "https://fhir.ee/CodeSystem/retsept-mahu-ja-massiyhik",
          "code" : "ML"
        }
      }
    }
  ]
}

```
