# ig-ee-medication-scheme#1.0.0: Medication Scheme Implementation Guide

## Pages

* [Home](index.md)
* [Documentation](documentation.md)
* [Operations](operations.md)
* [Checklist for developers](checklist.md)
* [Controls](controls.md)
* [Use cases](usecases.md)
* [Changes](changes.md)
* [About](other.md)
* [Contacts](contacts.md)
* [Known Issues](knownissues.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [Guidance](guidance.md)

## Resources

### CodeSystems

* [additional information TEST-CS](CodeSystem-additional-information.md)
* [Siseriiklik ATC](CodeSystem-atc-ee.md)
* [drug form groub TEST-CS](CodeSystem-drug-form-group.md)
* [failure degree TEST-CS](CodeSystem-failure-degree.md)
* [Toimeained](CodeSystem-toimeained.md)

### ValueSets

* [additional information TEST-VS](ValueSet-additional-information.md)
* [Siseriiklik ATC](ValueSet-atc-ee.md)
* [drug form groub TEST-VS](ValueSet-drug-form-group.md)
* [failure degree TEST-VS](ValueSet-failure-degree.md)
* [Toimeainete loend](ValueSet-toimeained.md)

### Complex-type Profiles

* [EETISAnnotation](StructureDefinition-ee-tis-annotation.md)
* [EETISDosage](StructureDefinition-ee-tis-dosage.md)

### Resource Profiles

* [EETISCommunication](StructureDefinition-ee-tis-communication.md)
* [EETISMedicationDispensedToPatient](StructureDefinition-ee-tis-medication-dispensed-to-patient.md)
* [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)
* [EETISMedicationExtemporal](StructureDefinition-ee-tis-medication-extemporal.md)
* [EETISMedicationInteraction](StructureDefinition-ee-tis-medication-interaction.md)
* [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md)
* [EETISMedicationRenalFunction](StructureDefinition-ee-tis-medication-renal-function.md)
* [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)
* [EETISObservationEGFR](StructureDefinition-ee-tis-observation-egfr.md)
* [EETISPharmacyLocation](StructureDefinition-ee-tis-pharmacy-location.md)
* [EETISPractitionerRole](StructureDefinition-ee-tis-practitioner-role.md)
* [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)
* [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* [EETISReimbursementTaskResponseParameters](StructureDefinition-ee-tis-reimbursement-task-response-parameters.md)
* [EETISReimbursementTask](StructureDefinition-ee-tis-reimbursement-task.md)
* [EETISRenalFailureDS](StructureDefinition-ee-tis-renal-failure-ds.md)

### Extensions

* [ExtensionEETISAdditionalInformationLink](StructureDefinition-ee-tis-additional-information-link.md)
* [ExtensionEETISAffectedMedicationStatements](StructureDefinition-ee-tis-affected-medication-statements.md)
* [ExtensionEETISBuyerEPC](StructureDefinition-ee-tis-buyer-epc.md)
* [ExtensionEETISCancelledStatusReason](StructureDefinition-ee-tis-cancelled-status-reason.md)
* [ExtensionEETISConsentWithInteractions](StructureDefinition-ee-tis-consent-with-interactions.md)
* [ExtensionEETISCourseOfTherapyType](StructureDefinition-ee-tis-course-of-therapy-type.md)
* [ExtensionEETISDispensationAuthorization](StructureDefinition-ee-tis-dispensation-authorization.md)
* [ExtensionEETISDosageModification](StructureDefinition-ee-tis-dosage-modification.md)
* [ExtensionEETISGroupedItems](StructureDefinition-ee-tis-grouped-items.md)
* [ExtensionEETISLockStatus](StructureDefinition-ee-tis-lock-status.md)
* [ExtensionEETISMedicationRemainder](StructureDefinition-ee-tis-medication-remainder.md)
* [ExtensionEETISMedicinalProductClassification](StructureDefinition-ee-tis-medicinal-product-classification.md)
* [ExtensionEETISMedicinalProductName](StructureDefinition-ee-tis-medicinal-product-name.md)
* [ExtensionEETISNephrotoxic](StructureDefinition-ee-tis-nephrotoxic.md)
* [ExtensionEETISPrescriptionChange](StructureDefinition-ee-tis-prescription-change.md)
* [ExtensionEETISPrescriptionIntent](StructureDefinition-ee-tis-prescription-intent.md)
* [ExtensionEETISPrescriptionValidityTime](StructureDefinition-ee-tis-prescription-validity-time.md)
* [ExtensionEETISReimbursementRate](StructureDefinition-ee-tis-reimbursement-rate.md)
* [ExtensionEETISRelatedObservationOrCondition](StructureDefinition-ee-tis-related-observation-or-condition.md)
* [ExtensionEETISRenalFailureWarning](StructureDefinition-ee-tis-renal-failure-warning.md)
* [ExtensionEETISSizeOfItem](StructureDefinition-ee-tis-size-of-item.md)
* [ExtensionEETISSubstitution](StructureDefinition-ee-tis-substitution.md)
* [ExtensionEETISTotalPrescribedAmount](StructureDefinition-ee-tis-total-prescribed-amount.md)
* [ExtensionEETISUnauthorizedProductRequest](StructureDefinition-ee-tis-unauthorized-product-request.md)
* [ExtensionEETISVerification](StructureDefinition-ee-tis-verification.md)

### ImplementationGuides

* [Medication Scheme Implementation Guide](index.md)

### OperationDefinitions

* [Find interactions for medications](OperationDefinition-Interactions.md)
* [Find renal failure warnings for medications](OperationDefinition-Medication-renal-failure-warnings.md)
* [Medication Statement Confirm](OperationDefinition-MedicationStatement-confirm.md)
* [Find confirmed medication scheme](OperationDefinition-MedicationStatement-confirmed-medication-scheme.md)
* [Get history of medication statements](OperationDefinition-MedicationStatement-history.md)
* [Validate MedicationStatement business rules](OperationDefinition-MedicationStatement-validate-custom.md)
* [Task reimbursements](OperationDefinition-Task-reimbursements.md)

### Examples

* [renal-function-failure (ClinicalUseDefinition)](ClinicalUseDefinition-renal-function-failure.md)
* [Comment-changed (Communication)](Communication-Comment-changed.md)
* [Comment1 (Communication)](Communication-Comment1.md)
* [comment-renal-failure (Communication)](Communication-comment-renal-failure.md)
* [Ravimiskeem, kinnitatud D12345 poolt (List)](List-listMatiMeri3.md)
* [Tehiku apteek (Location)](Location-tehiku-apteek.md)
* [TiamiinPyridoksiinTsyanokobalamiinLidokaiin (Medication)](Medication-TiamiinPyridoksiinTsyanokobalamiinLidokaiin.md)
* [adrenalin (Medication)](Medication-adrenalin.md)
* [adrenaline-renal-function (Medication)](Medication-adrenaline-renal-function.md)
* [alprazolam-dispensed (Medication)](Medication-alprazolam-dispensed.md)
* [alprazolam (Medication)](Medication-alprazolam.md)
* [aspirin (Medication)](Medication-aspirin.md)
* [dexamethason (Medication)](Medication-dexamethason.md)
* [extemporal (Medication)](Medication-extemporal.md)
* [fenoksymetyylpenitsilliin (Medication)](Medication-fenoksymetyylpenitsilliin.md)
* [metformin-dispensed (Medication)](Medication-metformin-dispensed.md)
* [metformin (Medication)](Medication-metformin.md)
* [novorapid (Medication)](Medication-novorapid.md)
* [dispensation-alprazolam (MedicationDispense)](MedicationDispense-dispensation-alprazolam.md)
* [dispensation-metformin (MedicationDispense)](MedicationDispense-dispensation-metformin.md)
* [prescription-adrenalin-pos-dec (MedicationRequest)](MedicationRequest-prescription-adrenalin-pos-dec.md)
* [prescription-alprazolam (MedicationRequest)](MedicationRequest-prescription-alprazolam.md)
* [prescription-cancelled (MedicationRequest)](MedicationRequest-prescription-cancelled.md)
* [prescription-metformin (MedicationRequest)](MedicationRequest-prescription-metformin.md)
* [MedicationStatement-complex-dosaging (MedicationStatement)](MedicationStatement-MedicationStatement-complex-dosaging.md)
* [MedicationStatement-metformin-grouped-items (MedicationStatement)](MedicationStatement-MedicationStatement-metformin-grouped-items.md)
* [MedicationStatement-metformin-historyView (MedicationStatement)](MedicationStatement-MedicationStatement-metformin-historyView.md)
* [MedicationStatement-metformin (MedicationStatement)](MedicationStatement-MedicationStatement-metformin.md)
* [MedicationStatementAlprazolam (MedicationStatement)](MedicationStatement-MedicationStatementAlprazolam.md)
* [observation-egfr1 (Observation)](Observation-observation-egfr1.md)
* [Rakvere Haigla (Organization)](Organization-rh.md)
* [parameters-response (Parameters)](Parameters-parameters-response.md)
* [pat1MatiMeri (Patient)](Patient-pat1MatiMeri.md)
* [D12345 (Practitioner)](Practitioner-D12345.md)
* [N98765 (Practitioner)](Practitioner-N98765.md)
* [PractRoleD12345 (PractitionerRole)](PractitionerRole-PractRoleD12345.md)
* [PractRoleN98765 (PractitionerRole)](PractitionerRole-PractRoleN98765.md)
* [pharmacistKristiina (PractitionerRole)](PractitionerRole-pharmacistKristiina.md)
