# ExtensionEETISVerification - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISVerification**

## Extension: ExtensionEETISVerification 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-verification | *Version*:1.0.0 |
| Draft as of 2024-02-23 | *Computable Name*:ExtensionEETISVerification |

Kinnitamine. This extension is used for the verification of the MedicationStatement - when practitioner changes, adds or deletes anything in patient's medication scheme it must be verified with date and id of the practitioner.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)
* Examples for this Extension: [MedicationStatement/MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md), [MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md), [MedicationStatement/MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md), [MedicationStatement/MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md) and [MedicationStatement/MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-verification)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-verification.csv), [Excel](StructureDefinition-ee-tis-verification.xlsx), [Schematron](StructureDefinition-ee-tis-verification.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-verification",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-verification",
  "version" : "1.0.0",
  "name" : "ExtensionEETISVerification",
  "status" : "draft",
  "date" : "2024-02-23T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Kinnitamine. This extension is used for the verification of the MedicationStatement - when practitioner changes, adds or deletes anything in patient's medication scheme it must be verified with date and id of the practitioner.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Verification of medication scheme",
        "definition" : "Ravimiskeemi rea kinnitamine"
      },
      {
        "id" : "Extension.extension:verificationTime",
        "path" : "Extension.extension",
        "sliceName" : "verificationTime",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:verificationTime.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:verificationTime.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "verificationTime"
      },
      {
        "id" : "Extension.extension:verificationTime.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Verification time",
        "definition" : "Kinnitamise aeg. Time when practitioner confirms the changes he/she makes in MedicationStatement.",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "Extension.extension:verificationAuthor",
        "path" : "Extension.extension",
        "sliceName" : "verificationAuthor",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:verificationAuthor.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:verificationAuthor.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "verificationAuthor"
      },
      {
        "id" : "Extension.extension:verificationAuthor.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Verification author",
        "definition" : "Ravimiskeemi kinnitaja. The author who verifies the changes made in MedicationStatement.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role"
            ]
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-verification"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
