# ExtensionEETISSizeOfItem - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISSizeOfItem**

## Extension: ExtensionEETISSizeOfItem 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-size-of-item | *Version*:1.0.0 |
| Draft as of 2023-10-03 | *Computable Name*:ExtensionEETISSizeOfItem |

Pakkeühiku suurus. Size of medicinal product item (3ml).

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md)
* Examples for this Extension: [Medication/TiamiinPyridoksiinTsyanokobalamiinLidokaiin](Medication-TiamiinPyridoksiinTsyanokobalamiinLidokaiin.md) and [Medication/adrenalin](Medication-adrenalin.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-size-of-item)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-size-of-item.csv), [Excel](StructureDefinition-ee-tis-size-of-item.xlsx), [Schematron](StructureDefinition-ee-tis-size-of-item.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-size-of-item",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-size-of-item",
  "version" : "1.0.0",
  "name" : "ExtensionEETISSizeOfItem",
  "status" : "draft",
  "date" : "2023-10-03T10:47:00.9373224+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Pakkeühiku suurus. Size of medicinal product item (3ml).",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Medication"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Size of medicinal product item (3ml). E.g. total volume of packaged medication is 30ml but it includes 10 items 3ml each.",
        "definition" : "Pakkeühiku suurus"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-size-of-item"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Size of medicinal product item",
        "definition" : "Pakkeühiku suurus (3ml). Näiteks pakendi kogumaht on 30ml aga see sisaldab 10 pakkeühikut suuruses 3ml.",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      }
    ]
  }
}

```
