# EETISRenalFailureDS - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISRenalFailureDS**

## Resource Profile: EETISRenalFailureDS 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-renal-failure-ds | *Version*:1.0.0 |
| Draft as of 2024-02-22 | *Computable Name*:EETISRenalFailureDS |

 
Neerufuntsiooni puudulikkuse otsustustoe vastus. This profile is for the representation of patient's renal function failure and alerts about it so the medication can be adjusted according to failure degree. 

**Usages:**

* Examples for this Profile: [ClinicalUseDefinition/renal-function-failure](ClinicalUseDefinition-renal-function-failure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-renal-failure-ds)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-renal-failure-ds.csv), [Excel](StructureDefinition-ee-tis-renal-failure-ds.xlsx), [Schematron](StructureDefinition-ee-tis-renal-failure-ds.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-renal-failure-ds",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-renal-failure-ds",
  "version" : "1.0.0",
  "name" : "EETISRenalFailureDS",
  "status" : "draft",
  "date" : "2024-02-22T14:32:30.0668499+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Neerufuntsiooni puudulikkuse otsustustoe vastus. This profile is for the representation of patient's renal function failure and alerts about it so the medication can be adjusted according to failure degree.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ClinicalUseDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalUseDefinition",
        "path" : "ClinicalUseDefinition"
      },
      {
        "id" : "ClinicalUseDefinition.contained",
        "path" : "ClinicalUseDefinition.contained",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Medication"
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension",
        "path" : "ClinicalUseDefinition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalUseDefinition.extension:affected",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "affected",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-affected-medication-statements"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension:link",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "link",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-additional-information-link"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension:nephrotoxic",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "nephrotoxic",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-nephrotoxic"]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension:dosageModification",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "dosageModification",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-dosage-modification"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension:relatedObservation",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "relatedObservation",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-related-observation-or-condition"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.type",
        "path" : "ClinicalUseDefinition.type",
        "fixedCode" : "undesirable-effect"
      },
      {
        "id" : "ClinicalUseDefinition.category",
        "path" : "ClinicalUseDefinition.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding"
            }
          ],
          "rules" : "open"
        },
        "short" : "RenBase drugFormGroup ja failureDegree"
      },
      {
        "id" : "ClinicalUseDefinition.category:drugFormGroup",
        "path" : "ClinicalUseDefinition.category",
        "sliceName" : "drugFormGroup",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalUseDefinition.category:drugFormGroup.coding",
        "path" : "ClinicalUseDefinition.category.coding",
        "short" : "0 | 1 | 2 | 3 | 4 | 5| This is a fake system for example. Do NOT use it!",
        "min" : 1,
        "patternCoding" : {
          "system" : "https://fhir.ee/CodeSystem/drug-form-group"
        }
      },
      {
        "id" : "ClinicalUseDefinition.category:failureDegree",
        "path" : "ClinicalUseDefinition.category",
        "sliceName" : "failureDegree",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalUseDefinition.category:failureDegree.coding",
        "path" : "ClinicalUseDefinition.category.coding",
        "short" : "Failure degree 0-4. Neerupuudulikkuse aste: number + selgitus. This is a fake system for example. Do NOT use it!",
        "min" : 1,
        "patternCoding" : {
          "system" : "https://fhir.ee/CodeSystem/failure-degree"
        }
      },
      {
        "id" : "ClinicalUseDefinition.category:additionalInformation",
        "path" : "ClinicalUseDefinition.category",
        "sliceName" : "additionalInformation",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ClinicalUseDefinition.category:additionalInformation.coding",
        "path" : "ClinicalUseDefinition.category.coding",
        "short" : "This is a fake system for example. Do NOT use it",
        "min" : 1,
        "patternCoding" : {
          "system" : "https://fhir.ee//CodeSystem/additional-information"
        }
      },
      {
        "id" : "ClinicalUseDefinition.subject",
        "path" : "ClinicalUseDefinition.subject",
        "short" : "medication that may cause renal function failure",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Medication"]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.subject.display",
        "path" : "ClinicalUseDefinition.subject.display",
        "patternString" : "Name of the medication/active inredient. Siia toimeaine nimetus"
      },
      {
        "id" : "ClinicalUseDefinition.contraindication",
        "path" : "ClinicalUseDefinition.contraindication",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.indication",
        "path" : "ClinicalUseDefinition.indication",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.population",
        "path" : "ClinicalUseDefinition.population",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.library",
        "path" : "ClinicalUseDefinition.library",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.undesirableEffect",
        "path" : "ClinicalUseDefinition.undesirableEffect",
        "short" : "Classification A/B/C/D and description how the dosage must be adjusted",
        "definition" : "Klassifikatsioon RenBase järgi ja kirjeldus kui palju annust tuleks muuta"
      },
      {
        "id" : "ClinicalUseDefinition.undesirableEffect.classification",
        "path" : "ClinicalUseDefinition.undesirableEffect.classification",
        "short" : "klassifikatsioon (A/B/C/D) + selle tekst nt C, text: Annust või annustamise vahemikku tuleb kohandada",
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "UndesirableEffectClassification"
            }
          ],
          "strength" : "example",
          "description" : "Use this fictive system https://fhir.ee/synbase-warning-classification",
          "valueSet" : "http://hl7.org/fhir/ValueSet/undesirable-effect-classification"
        }
      }
    ]
  }
}

```
