# EETISReimbursementTaskResponseParameters - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISReimbursementTaskResponseParameters**

## Resource Profile: EETISReimbursementTaskResponseParameters 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-reimbursement-task-response-parameters | *Version*:1.0.0 |
| Draft as of 2024-02-05 | *Computable Name*:EETISReimbursementTaskResponseParameters |

 
This resource passes information back to EETISReimbursementTask output about the e-Prescription Centre's answer of allowed reimbursement rates. Also, information about insurance, EU insurance, pension and pension for incapacity for work are passed back. 

**Usages:**

* Refer to this Profile: [EETISReimbursementTask](StructureDefinition-ee-tis-reimbursement-task.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-reimbursement-task-response-parameters)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-reimbursement-task-response-parameters.csv), [Excel](StructureDefinition-ee-tis-reimbursement-task-response-parameters.xlsx), [Schematron](StructureDefinition-ee-tis-reimbursement-task-response-parameters.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-reimbursement-task-response-parameters",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-task-response-parameters",
  "version" : "1.0.0",
  "name" : "EETISReimbursementTaskResponseParameters",
  "status" : "draft",
  "date" : "2024-02-05T14:08:48.1446292+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "This resource passes information back to EETISReimbursementTask output about the e-Prescription Centre's answer of allowed reimbursement rates. Also, information about insurance, EU insurance, pension and pension for incapacity for work are passed back.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Parameters",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Parameters",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Parameters",
        "path" : "Parameters"
      },
      {
        "id" : "Parameters.parameter",
        "path" : "Parameters.parameter",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "closed"
        },
        "short" : "Received reimbursement rate from EPC (Estonian Prescription Centre)"
      },
      {
        "id" : "Parameters.parameter:insuranceParameter",
        "path" : "Parameters.parameter",
        "sliceName" : "insuranceParameter",
        "short" : "A parameter received from the operation indicationg whether or not the patient is insured.",
        "definition" : "Kindlustatus",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Parameters.parameter:insuranceParameter.name",
        "path" : "Parameters.parameter.name",
        "short" : "Insurance response",
        "patternString" : "insuranceParameter"
      },
      {
        "id" : "Parameters.parameter:insuranceParameter.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:insuranceEUParameter",
        "path" : "Parameters.parameter",
        "sliceName" : "insuranceEUParameter",
        "short" : "A parameter received from the operation indication whether or not the patient has EU insurance.",
        "definition" : "EU kindlustatus",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Parameters.parameter:insuranceEUParameter.name",
        "path" : "Parameters.parameter.name",
        "short" : "EU insurance response",
        "patternString" : "insuranceEUParameter"
      },
      {
        "id" : "Parameters.parameter:insuranceEUParameter.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:oldAgePensionParameter",
        "path" : "Parameters.parameter",
        "sliceName" : "oldAgePensionParameter",
        "short" : "A parameter received from the operation indicationg whether or not the patient has old age pension.",
        "definition" : "Vanaduspension",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Parameters.parameter:oldAgePensionParameter.name",
        "path" : "Parameters.parameter.name",
        "short" : "Old age pension response",
        "patternString" : "oldAgePensionParameter"
      },
      {
        "id" : "Parameters.parameter:oldAgePensionParameter.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:incapacityForWorkPensionParameter",
        "path" : "Parameters.parameter",
        "sliceName" : "incapacityForWorkPensionParameter",
        "short" : "A parameter received from the operation indication whether the patient has pension for incapacity for work.",
        "definition" : "Töövõimetuspension",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Parameters.parameter:incapacityForWorkPensionParameter.name",
        "path" : "Parameters.parameter.name",
        "short" : "Pension for incapacity for work",
        "patternString" : "incapacityForWorkPensionParameter"
      },
      {
        "id" : "Parameters.parameter:incapacityForWorkPensionParameter.value[x]",
        "path" : "Parameters.parameter.value[x]",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter",
        "path" : "Parameters.parameter",
        "sliceName" : "reimbursementParameter",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part",
        "path" : "Parameters.parameter.part",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "name"
            }
          ],
          "rules" : "open"
        },
        "short" : "Received reimbursement rate from EPC (Estonian Prescription Centre)",
        "min" : 2
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part:condition",
        "path" : "Parameters.parameter.part",
        "sliceName" : "condition",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part:condition.name",
        "path" : "Parameters.parameter.part.name",
        "short" : "Received reimbursement Condition from EPC",
        "patternString" : "condition"
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part:condition.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part:rate",
        "path" : "Parameters.parameter.part",
        "sliceName" : "rate",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part:rate.name",
        "path" : "Parameters.parameter.part.name",
        "short" : "Received reimbursement rate from EPC",
        "patternString" : "rate"
      },
      {
        "id" : "Parameters.parameter:reimbursementParameter.part:rate.value[x]",
        "path" : "Parameters.parameter.part.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-soodustuse-maar"
        }
      }
    ]
  }
}

```
