# EETISPrescription - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISPrescription**

## Resource Profile: EETISPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-prescription | *Version*:1.0.0 |
| Draft as of 2024-02-21 | *Computable Name*:EETISPrescription |

 
Retsept. This is a profile for medication prescription. 

**Usages:**

* Refer to this Profile: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)
* Examples for this Profile: [MedicationRequest/prescription-adrenalin-pos-dec](MedicationRequest-prescription-adrenalin-pos-dec.md), [MedicationRequest/prescription-alprazolam](MedicationRequest-prescription-alprazolam.md), [MedicationRequest/prescription-cancelled](MedicationRequest-prescription-cancelled.md) and [MedicationRequest/prescription-metformin](MedicationRequest-prescription-metformin.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-prescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-prescription.csv), [Excel](StructureDefinition-ee-tis-prescription.xlsx), [Schematron](StructureDefinition-ee-tis-prescription.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-prescription",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-prescription",
  "version" : "1.0.0",
  "name" : "EETISPrescription",
  "status" : "draft",
  "date" : "2024-02-21T13:56:50.8906817+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Retsept. This is a profile for medication prescription.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationRequest",
        "path" : "MedicationRequest"
      },
      {
        "id" : "MedicationRequest.meta.lastUpdated",
        "path" : "MedicationRequest.meta.lastUpdated",
        "example" : [
          {
            "label" : "ajanäidis",
            "valueInstant" : "2023-09-25T12:12:12+00:01"
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension",
        "path" : "MedicationRequest.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MedicationRequest.extension:dispensationAuthorization",
        "path" : "MedicationRequest.extension",
        "sliceName" : "dispensationAuthorization",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:lockStatus",
        "path" : "MedicationRequest.extension",
        "sliceName" : "lockStatus",
        "short" : "Used only when requesting unauthorized medication.",
        "definition" : "Broneeritud müügiloata ravimi taotluse jaoks. Kasutatakse AINULT müügiloata ravimi taotluse retsepti broneerimise puhul.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-lock-status"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:extensionEETISUnauthorizedProductRequest",
        "path" : "MedicationRequest.extension",
        "sliceName" : "extensionEETISUnauthorizedProductRequest",
        "short" : "Used for requesting marketing permit for unauthorized medication.",
        "definition" : "Müügiloata ravimi taotluse tarvis.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-unauthorized-product-request"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:extensionEETISTotalPrescribedAmount",
        "path" : "MedicationRequest.extension",
        "sliceName" : "extensionEETISTotalPrescribedAmount",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-total-prescribed-amount"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:extensionEETISReimbursementRate",
        "path" : "MedicationRequest.extension",
        "sliceName" : "extensionEETISReimbursementRate",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.extension:extensionEETISPrescriptionChange",
        "path" : "MedicationRequest.extension",
        "sliceName" : "extensionEETISPrescriptionChange",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-prescription-change"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.identifier",
        "path" : "MedicationRequest.identifier",
        "short" : "Identifier for the prescription.",
        "definition" : "Retsepti unikaalne identifikaator. Identifiers associated with this medication request that are defined by business processes and/or used to refer to it when a direct URL reference to the resource itself is not appropriate. They are business identifiers assigned to this resource by the performer or other systems and remain constant as the resource is updated and propagates from server to server.",
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.identifier.system",
        "path" : "MedicationRequest.identifier.system",
        "short" : "Identifier system uri for Estonian Prescription Centre prescriptions",
        "patternUri" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept"
      },
      {
        "id" : "MedicationRequest.identifier.value",
        "path" : "MedicationRequest.identifier.value",
        "short" : "Prescription number"
      },
      {
        "id" : "MedicationRequest.identifier.assigner",
        "path" : "MedicationRequest.identifier.assigner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://fhir.ee/base/StructureDefinition/ee-organization"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.basedOn",
        "path" : "MedicationRequest.basedOn",
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.priorPrescription",
        "path" : "MedicationRequest.priorPrescription",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.status",
        "path" : "MedicationRequest.status",
        "definition" : "Kui tegemist on müügiloata ravimi taotlusega, on status siiski \"active\" , sest retsept on aktiivne ning kui müügiloa otsus on positiivne ja \"intent\" muutunud \"proposal\"-st \"order\"-ks extension lockStatus alt täpsustus, milline apteek retesepti broneeris ja retsept staatusesse \"on-hold. \r\n\r\nA code specifying the current state of the order. Generally, this will be active or completed state."
      },
      {
        "id" : "MedicationRequest.statusReason",
        "path" : "MedicationRequest.statusReason",
        "short" : "Reason for current status. Used only when prescription is \"cancelled\".",
        "definition" : "ANNULLEERIMISE PÕHJUS. LOEND. Kui retsept annulleeritakse, kasutatakse statust \"cancelled\" ning valitakse põhjus loendist \"Annulleerimise põhjuse\".\r\n\r\nCaptures the reason for the current state of the MedicationRequest.",
        "binding" : {
          "strength" : "required",
          "description" : "Annulleerimise põhjus loend",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-annulleerimise-pohjus"
        }
      },
      {
        "id" : "MedicationRequest.intent",
        "path" : "MedicationRequest.intent",
        "short" : "By default all requests are \"order\", unauthorized medication requests are initially \"proposal\" and when positively solved change to \"order\"",
        "definition" : "Tavaline retsept on \"order\", müügiloata ravimi retsept on alguses \"proposal\"."
      },
      {
        "id" : "MedicationRequest.category",
        "path" : "MedicationRequest.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "coding.system"
            }
          ],
          "rules" : "open"
        },
        "definition" : "RETSEPTI LIIK/DOK TYYP."
      },
      {
        "id" : "MedicationRequest.category:prescriptionCategory",
        "path" : "MedicationRequest.category",
        "sliceName" : "prescriptionCategory",
        "short" : "tavaretsept | narkootilise ravimi retsept | meditsiiniseadme retsept",
        "definition" : "RETSEPTI LIIK.",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "description" : "RETSEPTI LIIK. LOEND.",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-liik"
        }
      },
      {
        "id" : "MedicationRequest.category:prescriptionCategory.coding.system",
        "path" : "MedicationRequest.category.coding.system",
        "min" : 1,
        "patternUri" : "https://fhir.ee/CodeSystem/retsepti-liik"
      },
      {
        "id" : "MedicationRequest.category:repeatCategory",
        "path" : "MedicationRequest.category",
        "sliceName" : "repeatCategory",
        "short" : "1-kordne | 2-kordne | 3-kordne| 6-kordne",
        "definition" : "KORDSUS. LOEND.",
        "min" : 0,
        "max" : "1",
        "binding" : {
          "strength" : "required",
          "description" : "Retsepti kordsuse loend",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-kordsus"
        }
      },
      {
        "id" : "MedicationRequest.category:repeatCategory.coding.system",
        "path" : "MedicationRequest.category.coding.system",
        "min" : 1,
        "patternUri" : "https://fhir.ee/CodeSystem/retsepti-kordsus"
      },
      {
        "id" : "MedicationRequest.priority",
        "path" : "MedicationRequest.priority",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.doNotPerform",
        "path" : "MedicationRequest.doNotPerform",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.medication",
        "path" : "MedicationRequest.medication",
        "type" : [
          {
            "code" : "CodeableReference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-epc",
              "https://fhir.ee/StructureDefinition/ee-tis-medication-extemporal"
            ],
            "aggregation" : ["referenced"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.subject",
        "path" : "MedicationRequest.subject",
        "short" : "Patient for who is the request made for.",
        "definition" : "Patsient, kellele retsept on välja kirjutatud.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/mpi/StructureDefinition/ee-mpi-patient-verified"
            ],
            "aggregation" : ["referenced"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.informationSource",
        "path" : "MedicationRequest.informationSource",
        "short" : "If prescription is cancelled by someone else than original prescriber it must be filled here. Original prescriber remains in requester field.",
        "definition" : "Juhul kui retsept on annulleeritud kellegi teise poolt kui algne väljakirjutaja, tuleb annulleerija info siia tuua.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role",
              "https://fhir.ee/base/StructureDefinition/ee-practitioner"
            ]
          }
        ]
      },
      {
        "id" : "MedicationRequest.encounter",
        "path" : "MedicationRequest.encounter",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.authoredOn",
        "path" : "MedicationRequest.authoredOn",
        "short" : "When the prescription was made.",
        "definition" : "Koostamise aeg",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.requester",
        "path" : "MedicationRequest.requester",
        "short" : "Who/What requested the Request. Initial author of the request. NB! See also the differenece between informationSource",
        "definition" : "Kes tegi retsepti. Retsepti algne koostaja.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role",
              "https://fhir.ee/base/StructureDefinition/ee-practitioner"
            ],
            "aggregation" : ["contained"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.reported",
        "path" : "MedicationRequest.reported",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.performerType",
        "path" : "MedicationRequest.performerType",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.performer",
        "path" : "MedicationRequest.performer",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.device",
        "path" : "MedicationRequest.device",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.recorder",
        "path" : "MedicationRequest.recorder",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.reason",
        "path" : "MedicationRequest.reason",
        "short" : "Diagnosis according to ICD-10. Reason or indication for ordering or not ordering the medication",
        "definition" : "Diagnoosikood RHK-10 järgi.",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "preferred",
          "description" : "RHK-10",
          "valueSet" : "https://fhir.ee/ValueSet/rhk10"
        }
      },
      {
        "id" : "MedicationRequest.courseOfTherapyType",
        "path" : "MedicationRequest.courseOfTherapyType",
        "short" : "pidev | fikseeritud | vajadusel | muutuv | ühekordne",
        "binding" : {
          "strength" : "required",
          "description" : "RAVIKUURI TÜÜP. Loend",
          "valueSet" : "https://fhir.ee/ValueSet/ravikuuri-tyyp"
        }
      },
      {
        "id" : "MedicationRequest.courseOfTherapyType.coding",
        "path" : "MedicationRequest.courseOfTherapyType.coding",
        "short" : "pidev | fikseeritud | vajadusel | muutuv | ühekordne"
      },
      {
        "id" : "MedicationRequest.insurance",
        "path" : "MedicationRequest.insurance",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.note",
        "path" : "MedicationRequest.note",
        "short" : "Comment from the request author only.",
        "definition" : "Kommentaari saab lisada ainult sama inimene, kes koostas retsepti.\r\n\r\nExtra information about the prescription that could not be conveyed by the other attributes.",
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.note.author[x]",
        "path" : "MedicationRequest.note.author[x]",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.note.time",
        "path" : "MedicationRequest.note.time",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.renderedDosageInstruction",
        "path" : "MedicationRequest.renderedDosageInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.effectiveDosePeriod",
        "path" : "MedicationRequest.effectiveDosePeriod",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction",
        "path" : "MedicationRequest.dosageInstruction",
        "definition" : "ANNUSTAMINE. Täpne annustamisjuhis, kuidas määratud ravimit tuleb võtta.",
        "min" : 1,
        "type" : [
          {
            "code" : "Dosage",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-dosage"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dosageInstruction.sequence",
        "path" : "MedicationRequest.dosageInstruction.sequence",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.additionalInstruction",
        "path" : "MedicationRequest.dosageInstruction.additionalInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.event",
        "path" : "MedicationRequest.dosageInstruction.timing.event",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.countMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.countMax",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.duration",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.durationMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.durationMax",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequency",
        "short" : "Mitu korda (ajaühikus).",
        "definition" : "Indicates the number of repetitions that should occur within a period. I.e. Event occurs frequency times per period."
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.frequencyMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.frequencyMax",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.period",
        "definition" : "(mitu korda) aja(ühikus)."
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodMax",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodMax",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.periodUnit",
        "short" : "The units of time for the period in UCUM units",
        "definition" : "T(mitu korda aja)ühikus.\nNormal practice is to use the 'mo' code as a calendar month when calculating the next occurrence."
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.dayOfWeek",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.dayOfWeek",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.when",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.when",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.repeat.offset",
        "path" : "MedicationRequest.dosageInstruction.timing.repeat.offset",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.timing.code",
        "path" : "MedicationRequest.dosageInstruction.timing.code",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.asNeeded",
        "path" : "MedicationRequest.dosageInstruction.asNeeded",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.site",
        "path" : "MedicationRequest.dosageInstruction.site",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.route",
        "path" : "MedicationRequest.dosageInstruction.route",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.method",
        "path" : "MedicationRequest.dosageInstruction.method",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.type",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.type",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.dose[x]",
        "definition" : "RAVIMI KOGUS ÜHE KASUTUSKORRA AJAL.",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dosageInstruction.doseAndRate.rate[x]",
        "path" : "MedicationRequest.dosageInstruction.doseAndRate.rate[x]",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.maxDosePerPeriod",
        "path" : "MedicationRequest.dosageInstruction.maxDosePerPeriod",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.maxDosePerAdministration",
        "path" : "MedicationRequest.dosageInstruction.maxDosePerAdministration",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dosageInstruction.maxDosePerLifetime",
        "path" : "MedicationRequest.dosageInstruction.maxDosePerLifetime",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest",
        "path" : "MedicationRequest.dispenseRequest",
        "short" : "Indicates the specific details for the dispense or medication supply part of a medication request.",
        "definition" : "Täpne info ravimi väljamüügi kohta."
      },
      {
        "id" : "MedicationRequest.dispenseRequest.id",
        "path" : "MedicationRequest.dispenseRequest.id",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.initialFill",
        "path" : "MedicationRequest.dispenseRequest.initialFill",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.dispenseInterval",
        "path" : "MedicationRequest.dispenseRequest.dispenseInterval",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.validityPeriod",
        "path" : "MedicationRequest.dispenseRequest.validityPeriod",
        "definition" : "RETSEPTI KEHTIVUS AEG. Periood väljakirjutamise hetkest alates, mil on võimalik ravimit välja osta.",
        "min" : 1
      },
      {
        "id" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "path" : "MedicationRequest.dispenseRequest.numberOfRepeatsAllowed",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.quantity",
        "path" : "MedicationRequest.dispenseRequest.quantity",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "path" : "MedicationRequest.dispenseRequest.expectedSupplyDuration",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.dispenser",
        "path" : "MedicationRequest.dispenseRequest.dispenser",
        "definition" : "KASUTATAKSE AINULT MÜÜGILOATA RAVIMI APTEEGI BRONEERIMISE PUHUL. Indicates the intended performing Organization that will dispense the medication as specified by the prescriber.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://fhir.ee/base/StructureDefinition/ee-organization"],
            "aggregation" : ["referenced"]
          }
        ]
      },
      {
        "id" : "MedicationRequest.dispenseRequest.dispenserInstruction",
        "path" : "MedicationRequest.dispenseRequest.dispenserInstruction",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.dispenseRequest.doseAdministrationAid",
        "path" : "MedicationRequest.dispenseRequest.doseAdministrationAid",
        "max" : "0"
      },
      {
        "id" : "MedicationRequest.substitution",
        "path" : "MedicationRequest.substitution",
        "short" : "Asendamine. Any restrictions on medication substitution"
      },
      {
        "id" : "MedicationRequest.substitution.allowed[x]",
        "path" : "MedicationRequest.substitution.allowed[x]",
        "short" : "True if the prescriber allows a different drug to be dispensed from what was prescribed.",
        "definition" : "Kas asendamine on keelatud.",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      },
      {
        "id" : "MedicationRequest.substitution.reason",
        "path" : "MedicationRequest.substitution.reason",
        "definition" : "Asendamatuse põhjus (loend). \r\n\r\nIndicates the reason for the substitution, or why substitution must not be performed.",
        "binding" : {
          "strength" : "preferred",
          "description" : "Asendamatuse põhjus. Loend",
          "valueSet" : "https://fhir.ee/ValueSet/ravimi-asendamatuse-pohjus"
        }
      },
      {
        "id" : "MedicationRequest.eventHistory",
        "path" : "MedicationRequest.eventHistory",
        "max" : "0"
      }
    ]
  }
}

```
