# ExtensionEETISNephrotoxic - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISNephrotoxic**

## Extension: ExtensionEETISNephrotoxic 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-nephrotoxic | *Version*:1.0.0 |
| Draft as of 2024-08-23 | *Computable Name*:ExtensionEETISNephrotoxic |

Asendamine lubatud. Reason for not allowing the substitution of medication.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISRenalFailureDS](StructureDefinition-ee-tis-renal-failure-ds.md)
* Examples for this Extension: [ClinicalUseDefinition/renal-function-failure](ClinicalUseDefinition-renal-function-failure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-nephrotoxic)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-nephrotoxic.csv), [Excel](StructureDefinition-ee-tis-nephrotoxic.xlsx), [Schematron](StructureDefinition-ee-tis-nephrotoxic.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-nephrotoxic",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-nephrotoxic",
  "version" : "1.0.0",
  "name" : "ExtensionEETISNephrotoxic",
  "status" : "draft",
  "date" : "2024-08-23T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Asendamine lubatud. Reason for not allowing the substitution of medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClinicalUseDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Is the medication nephrotoxic or not.",
        "definition" : "Nefrotoksilisus"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-nephrotoxic"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Nephrotoxic = true, not nephrotoxic = false",
        "definition" : "Ravim nefrotoksiline jah/ei",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
