# ExtensionEETISMedicinalProductClassification - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISMedicinalProductClassification**

## Extension: ExtensionEETISMedicinalProductClassification 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification | *Version*:1.0.0 |
| Draft as of 2024-02-15 | *Computable Name*:ExtensionEETISMedicinalProductClassification |

Klassifikatsioon. Classification of the product, e.g. ATC, narcotic/psychtropic or prescription/over-the-counter medication

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationEPC](StructureDefinition-ee-tis-medication-epc.md) and [EETISMedicationRenalFunction](StructureDefinition-ee-tis-medication-renal-function.md)
* Examples for this Extension: [ClinicalUseDefinition/renal-function-failure](ClinicalUseDefinition-renal-function-failure.md), [Medication/TiamiinPyridoksiinTsyanokobalamiinLidokaiin](Medication-TiamiinPyridoksiinTsyanokobalamiinLidokaiin.md), [Medication/adrenalin](Medication-adrenalin.md), [Medication/adrenaline-renal-function](Medication-adrenaline-renal-function.md)...Show 6 more,[Medication/alprazolam](Medication-alprazolam.md),[Medication/aspirin](Medication-aspirin.md),[Medication/dexamethason](Medication-dexamethason.md),[Medication/fenoksymetyylpenitsilliin](Medication-fenoksymetyylpenitsilliin.md),[Medication/metformin](Medication-metformin.md)and[Medication/novorapid](Medication-novorapid.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medicinal-product-classification)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medicinal-product-classification.csv), [Excel](StructureDefinition-ee-tis-medicinal-product-classification.xlsx), [Schematron](StructureDefinition-ee-tis-medicinal-product-classification.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medicinal-product-classification",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification",
  "version" : "1.0.0",
  "name" : "ExtensionEETISMedicinalProductClassification",
  "status" : "draft",
  "date" : "2024-02-15T06:15:37.9998371+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Klassifikatsioon. Classification of the product, e.g. ATC, narcotic/psychtropic or prescription/over-the-counter medication",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Medication"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Classifications of the product, e.g ATC, narcotic/psychotropic, orphan drug, OTC medication etc.",
        "definition" : "Klassifikatsioon. Classification of the product, e.g. ATC, narcotic/psychtropic or prescription/over-the-counter medication"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Medication classified according to some defined system.",
        "definition" : "Ravimi klassifikatsioon (näiteks käsimüügiravim/retseptiravim, narkootiline/psühhotroopne jne)",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
