# EETISMedicationStatement - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationStatement**

## Resource Profile: EETISMedicationStatement 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-statement | *Version*:1.0.0 |
| Draft as of 2024-02-23 | *Computable Name*:EETISMedicationStatement |

 
Ravimiskeemi rida. One or more Medication Statements form patient's Medication Scheme. 

**Usages:**

* Refer to this Profile: [ExtensionEETISAffectedMedicationStatements](StructureDefinition-ee-tis-affected-medication-statements.md), [ExtensionEETISGroupedItems](StructureDefinition-ee-tis-grouped-items.md), [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md), [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISReimbursementTask](StructureDefinition-ee-tis-reimbursement-task.md)
* Examples for this Profile: [MedicationStatement/MedicationStatement-complex-dosaging](MedicationStatement-MedicationStatement-complex-dosaging.md), [MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md), [MedicationStatement/MedicationStatement-metformin-historyView](MedicationStatement-MedicationStatement-metformin-historyView.md), [MedicationStatement/MedicationStatement-metformin](MedicationStatement-MedicationStatement-metformin.md) and [MedicationStatement/MedicationStatementAlprazolam](MedicationStatement-MedicationStatementAlprazolam.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-statement)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-statement.csv), [Excel](StructureDefinition-ee-tis-medication-statement.xlsx), [Schematron](StructureDefinition-ee-tis-medication-statement.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-statement",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-statement",
  "version" : "1.0.0",
  "name" : "EETISMedicationStatement",
  "status" : "draft",
  "date" : "2024-02-23T10:56:02.4427313+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimiskeemi rida. One or more Medication Statements form patient's Medication Scheme.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationStatement",
        "path" : "MedicationStatement"
      },
      {
        "id" : "MedicationStatement.text",
        "path" : "MedicationStatement.text",
        "short" : "MedicationStatement is part of Medication Scheme representing one treatmentline"
      },
      {
        "id" : "MedicationStatement.extension",
        "path" : "MedicationStatement.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISPrescriptionValidityTime",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISPrescriptionValidityTime",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-prescription-validity-time"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISMedicationRemainder",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISMedicationRemainder",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-remainder"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISTotalPrescribedAmount",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISTotalPrescribedAmount",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-total-prescribed-amount"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISDispensationAuthorization",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISDispensationAuthorization",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-dispensation-authorization"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISCancelledStatusReason",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISCancelledStatusReason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-cancelled-status-reason"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISReimbursementRate",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISReimbursementRate",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-reimbursement-rate"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISUnauthorizedProductRequest",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISUnauthorizedProductRequest",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-unauthorized-product-request"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISSubstitution",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISSubstitution",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-substitution"]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISVerification",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISVerification",
        "definition" : "Optional Extension Element - found in all resources.",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-verification"]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:extensionEETISPrescriptionIntent",
        "path" : "MedicationStatement.extension",
        "sliceName" : "extensionEETISPrescriptionIntent",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-prescription-intent"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:ExtensionEETISPrescriptionChange",
        "path" : "MedicationStatement.extension",
        "sliceName" : "ExtensionEETISPrescriptionChange",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-prescription-change"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.extension:ExtensionEETISGroupedItems",
        "path" : "MedicationStatement.extension",
        "sliceName" : "ExtensionEETISGroupedItems",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-grouped-items"]
          }
        ]
      },
      {
        "id" : "MedicationStatement.identifier",
        "path" : "MedicationStatement.identifier",
        "short" : "Identifier is prescription number (ee RETSEPTINUMBER), if the MedicationStatement is generated from RETSEPTIKESKUS prescriptions. In history view identifier system must be used in order to group medications eg. in same dose form etc."
      },
      {
        "id" : "MedicationStatement.partOf",
        "path" : "MedicationStatement.partOf",
        "type" : [
          {
            "extension" : [
              {
                "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-hierarchy",
                "valueBoolean" : true
              }
            ],
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.status",
        "path" : "MedicationStatement.status",
        "short" : "A code representing the status of recording the medication statement. recorded = KINNITATUD; draft = KINNITAMATA",
        "definition" : "recorded = Kinnitatud; draft = Kinnitamata. Retseptikeskuse retsepti põhjal genereeritud kinnitamata rida on staatuses recorded/kinnitatud."
      },
      {
        "id" : "MedicationStatement.category",
        "path" : "MedicationStatement.category",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "min" : 3
      },
      {
        "id" : "MedicationStatement.category:courseOfTherapyType",
        "path" : "MedicationStatement.category",
        "sliceName" : "courseOfTherapyType",
        "short" : "What type of medication course is. RAVIKUURI TÜÜP. LOEND. pidev | fikseeritud | vajadusel | muutuv | ühekordne |",
        "definition" : "RAVIKUURI TÜÜP. LOEND. pidev | fikseeritud | vajadusel | muutuv | ühekordne |",
        "min" : 1,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.ee/ValueSet/ravikuuri-tyyp"
        }
      },
      {
        "id" : "MedicationStatement.category:prescriptionCategory",
        "path" : "MedicationStatement.category",
        "sliceName" : "prescriptionCategory",
        "short" : "Whether the prescription is for regular medication, narcotics or medical device.RETSEPTI LIIK. LOEND. tavaretsept | narkootilise ravimi retsept | meditsiiniseadme retsept",
        "definition" : "RETSEPTI LIIK. LOEND. tavaretsept | narkootilise ravimi retsept | meditsiiniseadme retsept",
        "min" : 1,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-liik"
        }
      },
      {
        "id" : "MedicationStatement.category:repeatCategory",
        "path" : "MedicationStatement.category",
        "sliceName" : "repeatCategory",
        "short" : "Whether the prescription is one-time prescription or multiple.RETSEPTI KORDSUS. LOEND. 1-kordne | 2-kordne | 3-kordne | 6-kordne",
        "definition" : "RETSEPTI KORDSUS. LOEND. 1-kordne | 2-kordne | 3-kordne | 6-kordne",
        "min" : 1,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-kordsus"
        }
      },
      {
        "id" : "MedicationStatement.category:statementOriginCategory",
        "path" : "MedicationStatement.category",
        "sliceName" : "statementOriginCategory",
        "short" : "Category defining the origin of MedicationStatement. USED ONLY when medication scheme line is based on patient's statement.",
        "definition" : "Seda kategooriat kasutada AINULT juhul, kui ravimiskeemi rida genereeritakse patsiendi sõnul. Kasutada koodi |ASK| loendist ravimi-andmete-tyyp. Retseptikeskuse retseptidest loodud ravimiskeemi rea puhul jääb see kategooria TÜHJAKS.",
        "min" : 0,
        "max" : "*",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://fhir.ee/ValueSet/ravimi-andmete-tyyp"
        }
      },
      {
        "id" : "MedicationStatement.medication",
        "path" : "MedicationStatement.medication",
        "type" : [
          {
            "code" : "CodeableReference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-epc",
              "https://fhir.ee/StructureDefinition/ee-tis-medication-extemporal"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.subject",
        "path" : "MedicationStatement.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/mpi/StructureDefinition/ee-mpi-patient-verified"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.encounter",
        "path" : "MedicationStatement.encounter",
        "max" : "0"
      },
      {
        "id" : "MedicationStatement.effective[x]",
        "path" : "MedicationStatement.effective[x]",
        "short" : "Time period when the treatment line begins and ends",
        "definition" : "Ravimiskeemi rea kehtivuse algus",
        "min" : 1,
        "type" : [
          {
            "code" : "Period"
          }
        ]
      },
      {
        "id" : "MedicationStatement.informationSource",
        "path" : "MedicationStatement.informationSource",
        "short" : "Initial author of the MedicationStatement. The person or organization that provided the information about the taking of this medication. Note: Use derivedFrom when a MedicationStatement is derived from other resources, e.g. Claim or MedicationRequest.",
        "definition" : "AUTOR KES KOOSTAB RAVIMISKEEMI REA (arst). Ravimiskeemi rea (algne) koostaja.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/base/StructureDefinition/ee-practitioner",
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role"
            ]
          }
        ]
      },
      {
        "id" : "MedicationStatement.derivedFrom",
        "path" : "MedicationStatement.derivedFrom",
        "short" : "Prescriptions created elsewhere than in TJT. Link to information used to derive the MedicationStatement",
        "definition" : "SEOTUD RETSEPTID.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["https://fhir.ee/StructureDefinition/ee-tis-prescription"],
            "aggregation" : ["referenced"]
          }
        ]
      },
      {
        "id" : "MedicationStatement.reason",
        "path" : "MedicationStatement.reason",
        "short" : "Diagnose for medication. ICD-10 codes from Estonian Prescription Centre. Reimbursement of medication depends on which ICD-10 code is used.",
        "definition" : "Diagnoosikoodid (RHK-10)\r\nDIAGNOOSIKOOD retseptikeskusest",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/rhk10"
        }
      },
      {
        "id" : "MedicationStatement.note",
        "path" : "MedicationStatement.note",
        "short" : "Siia saab kirjutada märkusi ravimiskeemi rea kohta."
      },
      {
        "id" : "MedicationStatement.note.author[x]",
        "path" : "MedicationStatement.note.author[x]",
        "min" : 1
      },
      {
        "id" : "MedicationStatement.relatedClinicalInformation",
        "path" : "MedicationStatement.relatedClinicalInformation",
        "max" : "0"
      },
      {
        "id" : "MedicationStatement.dosage",
        "path" : "MedicationStatement.dosage",
        "short" : "Indicates how the medication is/was or should be taken by the patient.",
        "definition" : "ANNUSTAMISEJUHIS",
        "type" : [
          {
            "code" : "Dosage",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-dosage"]
          }
        ]
      },
      {
        "id" : "MedicationStatement.dosage.additionalInstruction",
        "path" : "MedicationStatement.dosage.additionalInstruction",
        "short" : "Supplemental instructions to the patient on how to take the medication  (e.g. \"with meals\" or\"take half to one hour before food\") or warnings for the patient about the medication (e.g. \"may cause drowsiness\" or \"avoid exposure of skin to direct sunlight or sunlamps\").",
        "definition" : "VALMISTAMISEJUHIS"
      },
      {
        "id" : "MedicationStatement.dosage.maxDosePerAdministration.unit",
        "path" : "MedicationStatement.dosage.maxDosePerAdministration.unit",
        "max" : "0"
      },
      {
        "id" : "MedicationStatement.adherence",
        "path" : "MedicationStatement.adherence",
        "max" : "0"
      }
    ]
  }
}

```
