# EETISMedicationRenalFunction - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationRenalFunction**

## Resource Profile: EETISMedicationRenalFunction 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-renal-function | *Version*:1.0.0 |
| Draft as of 2024-02-14 | *Computable Name*:EETISMedicationRenalFunction |

 
Ravim neerufunktsiooni päringu sisendis. Medication resource for input when validating renal function. 

**Usages:**

* Examples for this Profile: [Medication/adrenaline-renal-function](Medication-adrenaline-renal-function.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-renal-function)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-renal-function.csv), [Excel](StructureDefinition-ee-tis-medication-renal-function.xlsx), [Schematron](StructureDefinition-ee-tis-medication-renal-function.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-renal-function",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-renal-function",
  "version" : "1.0.0",
  "name" : "EETISMedicationRenalFunction",
  "status" : "draft",
  "date" : "2024-02-14T14:34:42.5909877+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravim neerufunktsiooni päringu sisendis. Medication resource for input when validating renal function.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.meta.versionId",
        "path" : "Medication.meta.versionId",
        "example" : [
          {
            "label" : "versionId",
            "valueId" : "1"
          }
        ]
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Medication.extension:atc",
        "path" : "Medication.extension",
        "sliceName" : "atc",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:name",
        "path" : "Medication.extension",
        "sliceName" : "name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name"
            ]
          }
        ]
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "short" : "Package code when medication is prescribed based on specific package. ATC is found in extension.",
        "definition" : "Pakendi kood (pakendipõhisel retseptil)."
      },
      {
        "id" : "Medication.identifier.system",
        "path" : "Medication.identifier.system",
        "min" : 1,
        "patternUri" : "http://ravimiregister.ee/pakendid"
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "max" : "0"
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "max" : "0"
      },
      {
        "id" : "Medication.marketingAuthorizationHolder",
        "path" : "Medication.marketingAuthorizationHolder",
        "max" : "0"
      },
      {
        "id" : "Medication.doseForm",
        "path" : "Medication.doseForm",
        "short" : "Dose form of the medication. E.g powder, tablet, ointment etc.",
        "definition" : "Väljakirjutatud ravimi ravimvorm (loendist). Nt. pulber, tablett, salv jne",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/ravimvormid"
        }
      },
      {
        "id" : "Medication.ingredient",
        "path" : "Medication.ingredient",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.item",
        "path" : "Medication.ingredient.item",
        "short" : "Active ingredient from Ravimiregister value set",
        "definition" : "Toimeaine loendist. Ravimiregistri loend",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/toimeained"
        }
      },
      {
        "id" : "Medication.ingredient.isActive",
        "path" : "Medication.ingredient.isActive",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.isActive.value",
        "path" : "Medication.ingredient.isActive.value",
        "patternBoolean" : true
      },
      {
        "id" : "Medication.ingredient.strength[x]",
        "path" : "Medication.ingredient.strength[x]",
        "short" : "Strenght ratio of the active ingredient",
        "definition" : "Toimeaine tugevus",
        "min" : 1,
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "Medication.batch",
        "path" : "Medication.batch",
        "max" : "0"
      },
      {
        "id" : "Medication.definition",
        "path" : "Medication.definition",
        "max" : "0"
      }
    ]
  }
}

```
