# EETISMedicationList - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationList**

## Resource Profile: EETISMedicationList 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-list | *Version*:1.0.0 |
| Draft as of 2024-01-19 | *Computable Name*:EETISMedicationList |

 
Ravimiskeem. This profile gathers patient's medications in one list for better overview of the whole medication scheme 

**Usages:**

* Examples for this Profile: [List/listMatiMeri3](List-listMatiMeri3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-list)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-list.csv), [Excel](StructureDefinition-ee-tis-medication-list.xlsx), [Schematron](StructureDefinition-ee-tis-medication-list.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-list",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-list",
  "version" : "1.0.0",
  "name" : "EETISMedicationList",
  "status" : "draft",
  "date" : "2024-01-19T13:17:15.4473399+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimiskeem. This profile gathers patient's medications in one list for better overview of the whole medication scheme",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "xds",
      "uri" : "http://ihe.net/xds",
      "name" : "XDS metadata equivalent"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "List",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/List",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "List",
        "path" : "List",
        "short" : "Medication scheme. List of patient's medication.",
        "definition" : "RAVIMISKEEM"
      },
      {
        "id" : "List.extension",
        "path" : "List.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "List.extension:consent",
        "path" : "List.extension",
        "sliceName" : "consent",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-consent-with-interactions"
            ]
          }
        ]
      },
      {
        "id" : "List.extension:renalFailureWarning",
        "path" : "List.extension",
        "sliceName" : "renalFailureWarning",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-renal-failure-warning"
            ]
          }
        ]
      },
      {
        "id" : "List.status",
        "path" : "List.status",
        "fixedCode" : "current"
      },
      {
        "id" : "List.mode",
        "path" : "List.mode",
        "fixedCode" : "snapshot"
      },
      {
        "id" : "List.title",
        "path" : "List.title",
        "short" : "Medication Scheme",
        "definition" : "Ravimiskeem"
      },
      {
        "id" : "List.code",
        "path" : "List.code",
        "short" : "Ravimiskeem",
        "definition" : "kas on vaja teha oma koodisüsteem? Lahtine küsimus tuleviku aruteludeks",
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/list-example-use-codes",
              "code" : "medications",
              "display" : "Medication List"
            }
          ],
          "text" : "Medication List"
        }
      },
      {
        "id" : "List.subject",
        "path" : "List.subject",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/mpi/StructureDefinition/ee-mpi-patient-verified"
            ]
          }
        ]
      },
      {
        "id" : "List.encounter",
        "path" : "List.encounter",
        "max" : "0"
      },
      {
        "id" : "List.source",
        "path" : "List.source",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/base/StructureDefinition/ee-practitioner",
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role"
            ]
          }
        ]
      },
      {
        "id" : "List.note",
        "path" : "List.note",
        "max" : "1",
        "type" : [
          {
            "code" : "Annotation",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-annotation"]
          }
        ]
      },
      {
        "id" : "List.entry.flag",
        "path" : "List.entry.flag",
        "short" : "Entry flag VS is a combination of two CS (HL7 and local CS). Use flag to indicate whether the medication schema line is changed, unchanged, grouped etc.",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/ravimiskeemi-rea-muutuse-tyyp"
        }
      },
      {
        "id" : "List.entry.deleted",
        "path" : "List.entry.deleted",
        "max" : "0"
      },
      {
        "id" : "List.entry.date",
        "path" : "List.entry.date",
        "short" : "When entry flag is unchanged entry date does not change. When entry flag is something else than ´unchanged´ the entry date is also changed",
        "definition" : "Entry.date kuupäev näitab seda kuupäeva, millal muudatus jõudis sinna seisu kus ta täna on. Entry.date displays the date when the entry changed."
      },
      {
        "id" : "List.entry.item",
        "path" : "List.entry.item",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
            ]
          }
        ]
      },
      {
        "id" : "List.emptyReason",
        "path" : "List.emptyReason",
        "max" : "0"
      }
    ]
  }
}

```
