# EETISMedicationInteraction - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationInteraction**

## Resource Profile: EETISMedicationInteraction 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-interaction | *Version*:1.0.0 |
| Draft as of 2024-02-22 | *Computable Name*:EETISMedicationInteraction |

 
Ravimite omavahelised koostoimed. This profile is for the representation of the interactions between medication A and medication B in order to display warnings related to medications. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-interaction)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-interaction.csv), [Excel](StructureDefinition-ee-tis-medication-interaction.xlsx), [Schematron](StructureDefinition-ee-tis-medication-interaction.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-interaction",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-interaction",
  "version" : "1.0.0",
  "name" : "EETISMedicationInteraction",
  "status" : "draft",
  "date" : "2024-02-22T14:32:30.0668499+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimite omavahelised koostoimed. This profile is for the representation of the interactions between medication A and medication B in order to display warnings related to medications.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "idmp",
      "uri" : "https://www.iso.org/obp/ui/#iso:std:iso:11615",
      "name" : "IDMP Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ClinicalUseDefinition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ClinicalUseDefinition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ClinicalUseDefinition",
        "path" : "ClinicalUseDefinition"
      },
      {
        "id" : "ClinicalUseDefinition.contained",
        "path" : "ClinicalUseDefinition.contained",
        "min" : 2,
        "max" : "2",
        "type" : [
          {
            "code" : "Medication"
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension",
        "path" : "ClinicalUseDefinition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "ClinicalUseDefinition.extension:affected",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "affected",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-affected-medication-statements"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.extension:link",
        "path" : "ClinicalUseDefinition.extension",
        "sliceName" : "link",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-additional-information-link"
            ]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.type",
        "path" : "ClinicalUseDefinition.type",
        "fixedCode" : "interaction"
      },
      {
        "id" : "ClinicalUseDefinition.subject",
        "path" : "ClinicalUseDefinition.subject",
        "short" : "medication A",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Medication"]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.subject.display",
        "path" : "ClinicalUseDefinition.subject.display",
        "patternString" : "siia toimeaine nimetus"
      },
      {
        "id" : "ClinicalUseDefinition.contraindication",
        "path" : "ClinicalUseDefinition.contraindication",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.indication",
        "path" : "ClinicalUseDefinition.indication",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.interactant.item[x]",
        "path" : "ClinicalUseDefinition.interaction.interactant.item[x]",
        "short" : "medication B",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Medication"]
          }
        ]
      },
      {
        "id" : "ClinicalUseDefinition.interaction.type",
        "path" : "ClinicalUseDefinition.interaction.type",
        "fixedCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/interaction-type",
              "code" : "drug-drug",
              "display" : "drug to drug interaction"
            }
          ],
          "text" : "drug to drug interaction"
        }
      },
      {
        "id" : "ClinicalUseDefinition.interaction.effect",
        "path" : "ClinicalUseDefinition.interaction.effect",
        "short" : "Consequences (SYNBASE)"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.effect.concept",
        "path" : "ClinicalUseDefinition.interaction.effect.concept",
        "short" : "Consequences"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.effect.concept.text",
        "path" : "ClinicalUseDefinition.interaction.effect.concept.text",
        "short" : "If not codeable, use text to represent consequenses"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.effect.reference",
        "path" : "ClinicalUseDefinition.interaction.effect.reference",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.incidence",
        "path" : "ClinicalUseDefinition.interaction.incidence",
        "short" : "Classification (SYNBASE. e.g. D0)",
        "definition" : "Kombinatsioon category all olevatest numbritest ja tähtedest. The incidence of the interaction, e.g. theoretical, observed."
      },
      {
        "id" : "ClinicalUseDefinition.interaction.incidence.text",
        "path" : "ClinicalUseDefinition.interaction.incidence.text",
        "short" : "Classification"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.management",
        "path" : "ClinicalUseDefinition.interaction.management",
        "short" : "Recommendation (SYNBASE)",
        "max" : "1"
      },
      {
        "id" : "ClinicalUseDefinition.interaction.management.text",
        "path" : "ClinicalUseDefinition.interaction.management.text",
        "short" : "If not codeable, use text to represent recommendation"
      },
      {
        "id" : "ClinicalUseDefinition.population",
        "path" : "ClinicalUseDefinition.population",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.library",
        "path" : "ClinicalUseDefinition.library",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.undesirableEffect",
        "path" : "ClinicalUseDefinition.undesirableEffect",
        "max" : "0"
      },
      {
        "id" : "ClinicalUseDefinition.warning",
        "path" : "ClinicalUseDefinition.warning",
        "max" : "0"
      }
    ]
  }
}

```
