# EETISMedicationEPC - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationEPC**

## Resource Profile: EETISMedicationEPC 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-epc | *Version*:1.0.0 |
| Draft as of 2024-02-14 | *Computable Name*:EETISMedicationEPC |

 
Ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions NOT on dispensations. 

**Usages:**

* Refer to this Profile: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)
* Examples for this Profile: [Medication/TiamiinPyridoksiinTsyanokobalamiinLidokaiin](Medication-TiamiinPyridoksiinTsyanokobalamiinLidokaiin.md), [Medication/adrenalin](Medication-adrenalin.md), [Medication/alprazolam](Medication-alprazolam.md), [Medication/aspirin](Medication-aspirin.md)...Show 4 more,[Medication/dexamethason](Medication-dexamethason.md),[Medication/fenoksymetyylpenitsilliin](Medication-fenoksymetyylpenitsilliin.md),[Medication/metformin](Medication-metformin.md)and[Medication/novorapid](Medication-novorapid.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-epc)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-epc.csv), [Excel](StructureDefinition-ee-tis-medication-epc.xlsx), [Schematron](StructureDefinition-ee-tis-medication-epc.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-epc",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-epc",
  "version" : "1.0.0",
  "name" : "EETISMedicationEPC",
  "status" : "draft",
  "date" : "2024-02-14T14:34:42.5909877+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions NOT on dispensations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.meta.versionId",
        "path" : "Medication.meta.versionId",
        "example" : [
          {
            "label" : "versionId",
            "valueId" : "1"
          }
        ]
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1
      },
      {
        "id" : "Medication.extension:atc",
        "path" : "Medication.extension",
        "sliceName" : "atc",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-classification"
            ]
          }
        ]
      },
      {
        "id" : "Medication.extension:sizeOfItem",
        "path" : "Medication.extension",
        "sliceName" : "sizeOfItem",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-size-of-item"]
          }
        ]
      },
      {
        "id" : "Medication.extension:name",
        "path" : "Medication.extension",
        "sliceName" : "name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name"
            ]
          }
        ]
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "Package code when medication is prescribed based on specific package. Slice prescriptionNumber is used for grouping medications in TJT. ATC is found in extension.",
        "definition" : "Pakendi kood (pakendipõhisel retseptil), või grupeerimiseks kasutatav retseptinumber"
      },
      {
        "id" : "Medication.identifier:packageNumber",
        "path" : "Medication.identifier",
        "sliceName" : "packageNumber",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Medication.identifier:packageNumber.system",
        "path" : "Medication.identifier.system",
        "min" : 1,
        "patternUri" : "http://ravimiregister.ee/pakendid"
      },
      {
        "id" : "Medication.identifier:prescriptionNumber",
        "path" : "Medication.identifier",
        "sliceName" : "prescriptionNumber",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Medication.identifier:prescriptionNumber.system",
        "path" : "Medication.identifier.system",
        "min" : 1,
        "patternUri" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept"
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "max" : "0"
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "max" : "0"
      },
      {
        "id" : "Medication.marketingAuthorizationHolder",
        "path" : "Medication.marketingAuthorizationHolder",
        "max" : "0"
      },
      {
        "id" : "Medication.doseForm",
        "path" : "Medication.doseForm",
        "short" : "Dose form of the medication. E.g powder, tablet, ointment etc.",
        "definition" : "Väljakirjutatud ravimi ravimvorm (loendist). Nt. pulber, tablett, salv jne",
        "min" : 1,
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/ravimvormid"
        }
      },
      {
        "id" : "Medication.totalVolume",
        "path" : "Medication.totalVolume",
        "short" : "If the certain medication (brand name) is chosen then total volume is the amount of medication in package. If based on just active ingredient then total volume is same as in MedicationStatement TotalPrescribedAmount.",
        "definition" : "Kui preparaat ON määratud, siis on ravimite hulk pakendis. Kui preparaat EI ole määratud, siis on see kogu välja kirjutatud hulk (ehk võrdne MedicationStatement extension andmetega).",
        "min" : 1,
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "Medication.totalVolume.value",
        "path" : "Medication.totalVolume.value",
        "short" : "Total volume of medication.",
        "definition" : "Ühikute koguhulk. Ainult number, nt 100",
        "min" : 1
      },
      {
        "id" : "Medication.totalVolume.unit",
        "path" : "Medication.totalVolume.unit",
        "max" : "0"
      },
      {
        "id" : "Medication.totalVolume.code",
        "path" : "Medication.totalVolume.code",
        "short" : "Unit for total volume",
        "definition" : "Ühikute koguhulga ühik"
      },
      {
        "id" : "Medication.ingredient",
        "path" : "Medication.ingredient",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.item",
        "path" : "Medication.ingredient.item",
        "short" : "Active ingredient from Ravimiregister value set",
        "definition" : "Toimeaine loendist. Ravimiregistri loend",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/toimeained"
        }
      },
      {
        "id" : "Medication.ingredient.isActive",
        "path" : "Medication.ingredient.isActive",
        "min" : 1
      },
      {
        "id" : "Medication.ingredient.isActive.value",
        "path" : "Medication.ingredient.isActive.value",
        "patternBoolean" : true
      },
      {
        "id" : "Medication.ingredient.strength[x]",
        "path" : "Medication.ingredient.strength[x]",
        "short" : "Strenght ratio of the active ingredient",
        "definition" : "Toimeaine tugevus",
        "min" : 1,
        "type" : [
          {
            "code" : "Ratio"
          }
        ]
      },
      {
        "id" : "Medication.batch",
        "path" : "Medication.batch",
        "max" : "0"
      },
      {
        "id" : "Medication.definition",
        "path" : "Medication.definition",
        "max" : "0"
      }
    ]
  }
}

```
