# EETISMedicationDispensedToPatient - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISMedicationDispensedToPatient**

## Resource Profile: EETISMedicationDispensedToPatient 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-medication-dispensed-to-patient | *Version*:1.0.0 |
| Draft as of 2024-02-14 | *Computable Name*:EETISMedicationDispensedToPatient |

 
Väljamüüdud ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions and dispensations. 

**Usages:**

* Refer to this Profile: [EETISPrescriptionDispense](StructureDefinition-ee-tis-prescription-dispense.md)
* Examples for this Profile: [Medication/alprazolam-dispensed](Medication-alprazolam-dispensed.md) and [Medication/metformin-dispensed](Medication-metformin-dispensed.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-medication-dispensed-to-patient)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-medication-dispensed-to-patient.csv), [Excel](StructureDefinition-ee-tis-medication-dispensed-to-patient.xlsx), [Schematron](StructureDefinition-ee-tis-medication-dispensed-to-patient.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-medication-dispensed-to-patient",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-medication-dispensed-to-patient",
  "version" : "1.0.0",
  "name" : "EETISMedicationDispensedToPatient",
  "status" : "draft",
  "date" : "2024-02-14T14:34:42.5909877+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Väljamüüdud ravim. Medication resource as it is presented today in Estonian e-Prescription center (Retseptikeskus). Used on prescriptions and dispensations.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "script10.6",
      "uri" : "http://ncpdp.org/SCRIPT10_6",
      "name" : "Mapping to NCPDP SCRIPT 10.6"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Medication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Medication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Medication",
        "path" : "Medication"
      },
      {
        "id" : "Medication.meta.versionId",
        "path" : "Medication.meta.versionId",
        "example" : [
          {
            "label" : "versionId",
            "valueId" : "1"
          }
        ]
      },
      {
        "id" : "Medication.extension",
        "path" : "Medication.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Medication.extension:name",
        "path" : "Medication.extension",
        "sliceName" : "name",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medicinal-product-name"
            ]
          }
        ]
      },
      {
        "id" : "Medication.identifier",
        "path" : "Medication.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "short" : "Package code when medication is prescribed based on specific package. Slice prescriptionNumber is used for grouping medications in TJT. ATC is found in extension.",
        "definition" : "Pakendi kood (pakendipõhisel retseptil), või grupeerimiseks kasutatav retseptinumber",
        "max" : "1"
      },
      {
        "id" : "Medication.identifier:packageNumber",
        "path" : "Medication.identifier",
        "sliceName" : "packageNumber",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Medication.identifier:packageNumber.system",
        "path" : "Medication.identifier.system",
        "min" : 1,
        "patternUri" : "http://ravimiregister.ee/pakendid"
      },
      {
        "id" : "Medication.identifier:prescriptionNumber",
        "path" : "Medication.identifier",
        "sliceName" : "prescriptionNumber",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Medication.identifier:prescriptionNumber.system",
        "path" : "Medication.identifier.system",
        "min" : 1,
        "patternUri" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept"
      },
      {
        "id" : "Medication.code",
        "path" : "Medication.code",
        "max" : "0"
      },
      {
        "id" : "Medication.status",
        "path" : "Medication.status",
        "max" : "0"
      },
      {
        "id" : "Medication.marketingAuthorizationHolder",
        "path" : "Medication.marketingAuthorizationHolder",
        "max" : "0"
      }
    ]
  }
}

```
