# ExtensionEETISGroupedItems - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISGroupedItems**

## Extension: ExtensionEETISGroupedItems 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-grouped-items | *Version*:1.0.0 |
| Draft as of 2023-10-03 | *Computable Name*:ExtensionEETISGroupedItems |

Grupeerija. Used when there is a need to group several items that contain data about the same line of medication prescribed to the patient.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)
* Examples for this Extension: [MedicationStatement/MedicationStatement-metformin-grouped-items](MedicationStatement-MedicationStatement-metformin-grouped-items.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-grouped-items)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-grouped-items.csv), [Excel](StructureDefinition-ee-tis-grouped-items.xlsx), [Schematron](StructureDefinition-ee-tis-grouped-items.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-grouped-items",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-grouped-items",
  "version" : "1.0.0",
  "name" : "ExtensionEETISGroupedItems",
  "status" : "draft",
  "date" : "2023-10-03T10:47:00.9373224+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Grupeerija. Used when there is a need to group several items that contain data about the same line of medication prescribed to the patient.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Used when there is a need to group several items that contain data about the same line of medication prescribed to the patient.",
        "definition" : "Grupeerija. Viide ravimiskeemi reale, kus mitu ravimiskeemi rida on kokku grupeeritud."
      },
      {
        "id" : "Extension.extension:groupingReference",
        "path" : "Extension.extension",
        "sliceName" : "groupingReference",
        "short" : "Reference(s) of MedicationStatement which are shown as one line",
        "definition" : "Ravimiskeemi rea referents(id), mis on kokku grupeeritud.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:groupingReference.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:groupingReference.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "groupingReference"
      },
      {
        "id" : "Extension.extension:groupingReference.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/StructureDefinition/ee-tis-medication-statement"
            ]
          }
        ]
      },
      {
        "id" : "Extension.extension:groupingIdentifier",
        "path" : "Extension.extension",
        "sliceName" : "groupingIdentifier",
        "short" : "Identifier(s) of MedicationStatement which are shown as one line",
        "definition" : "Ravimiskeemi rea identifikaator(id), mis on kokku grupeeritud.",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Extension.extension:groupingIdentifier.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:groupingIdentifier.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "groupingIdentifier"
      },
      {
        "id" : "Extension.extension:groupingIdentifier.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Identifier"
          }
        ]
      },
      {
        "id" : "Extension.extension:groupingIdentifier.value[x].system",
        "path" : "Extension.extension.value[x].system",
        "patternUri" : "https://fhir.ee/CodeSystem/tis-fhir-identifikaatorid/retseptikeskus-retsept"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-grouped-items"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
