# EETISDosage - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISDosage**

## Data Type Profile: EETISDosage 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-dosage | *Version*:1.0.0 |
| Draft as of 2024-01-31 | *Computable Name*:EETISDosage |

 
Annustamisjuhis. Dosage is for exact representation of what quantity in which units and how often should medication be taken by patient. 

**Usages:**

* Use this DataType Profile: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md) and [EETISPrescription](StructureDefinition-ee-tis-prescription.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-dosage)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-dosage.csv), [Excel](StructureDefinition-ee-tis-dosage.xlsx), [Schematron](StructureDefinition-ee-tis-dosage.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-dosage",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-dosage",
  "version" : "1.0.0",
  "name" : "EETISDosage",
  "status" : "draft",
  "date" : "2024-01-31T13:55:03.1985103+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Annustamisjuhis. Dosage is for exact representation of what quantity in which units and how often should medication be taken by patient.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 V2 Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Dosage",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Dosage",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Dosage",
        "path" : "Dosage",
        "short" : "Dosage",
        "definition" : "Annustamisjuhis"
      },
      {
        "id" : "Dosage.sequence",
        "path" : "Dosage.sequence",
        "definition" : "JÄRJEKORD."
      },
      {
        "id" : "Dosage.text",
        "path" : "Dosage.text",
        "maxLength" : 1000
      },
      {
        "id" : "Dosage.additionalInstruction",
        "path" : "Dosage.additionalInstruction",
        "definition" : "LISAJUHIS."
      },
      {
        "id" : "Dosage.patientInstruction",
        "path" : "Dosage.patientInstruction",
        "definition" : "KOMMENTAAR PATSIENDILE."
      },
      {
        "id" : "Dosage.timing",
        "path" : "Dosage.timing",
        "definition" : "ANNUSTAMISE AEG."
      },
      {
        "id" : "Dosage.timing.repeat",
        "path" : "Dosage.timing.repeat",
        "short" : "When the event is to occur.",
        "definition" : "ANNUSTAMISE KORDUS."
      },
      {
        "id" : "Dosage.timing.repeat.bounds[x]",
        "path" : "Dosage.timing.repeat.bounds[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "rules" : "open"
        },
        "short" : "Length/Range of lengths, or (Start and/or end) limits.",
        "definition" : "Ravikuuri piirid (pikkus/ulatus/kestus). Either a duration for the length of the timing schedule, a range of possible length, or outer bounds for start and/or end limits of the timing schedule."
      },
      {
        "id" : "Dosage.timing.repeat.count",
        "path" : "Dosage.timing.repeat.count",
        "definition" : "KORDUSED."
      },
      {
        "id" : "Dosage.timing.repeat.countMax",
        "path" : "Dosage.timing.repeat.countMax",
        "definition" : "MAKSIMAALNE KORDUSTE ARV. If present, indicates that the count is a range - so to perform the action between [count] and [countMax] times."
      },
      {
        "id" : "Dosage.timing.repeat.duration",
        "path" : "Dosage.timing.repeat.duration",
        "definition" : "KESTUS. How long this thing happens for when it happens. If durationMax is present, this element indicates the lower bound of the allowed range of the duration."
      },
      {
        "id" : "Dosage.timing.repeat.durationMax",
        "path" : "Dosage.timing.repeat.durationMax",
        "definition" : "MAKSIMAALNE KESTUS. If present, indicates that the duration is a range - so to perform the action between [duration] and [durationMax] time length."
      },
      {
        "id" : "Dosage.timing.repeat.durationUnit",
        "path" : "Dosage.timing.repeat.durationUnit",
        "short" : "The units of time for the duration.",
        "definition" : "KESTUS ja ÜHIK. The units of time for the duration, in UCUM units\nNormal practice is to use the 'mo' code as a calendar month when calculating the next occurrence."
      },
      {
        "id" : "Dosage.timing.repeat.frequency",
        "path" : "Dosage.timing.repeat.frequency",
        "definition" : "SAGEDUS. Ühekordse annuse kordsus/annustamiste arv perioodis. The number of times to repeat the action within the specified period. If frequencyMax is present, this element indicates the lower bound of the allowed range of the frequency."
      },
      {
        "id" : "Dosage.timing.repeat.frequencyMax",
        "path" : "Dosage.timing.repeat.frequencyMax",
        "definition" : "MAKSIMAALNE ANNUSTAMISTE ARV. If present, indicates that the frequency is a range - so to repeat between [frequency] and [frequencyMax] times within the period or period range."
      },
      {
        "id" : "Dosage.timing.repeat.period",
        "path" : "Dosage.timing.repeat.period",
        "definition" : "KUI SAGEDASTI ANNUSTATAKSE JA ÜHIK. Indicates the duration of time over which repetitions are to occur; e.g. to express \"3 times per day\", 3 would be the frequency and \"1 day\" would be the period. If periodMax is present, this element indicates the lower bound of the allowed range of the period length."
      },
      {
        "id" : "Dosage.timing.repeat.periodMax",
        "path" : "Dosage.timing.repeat.periodMax",
        "definition" : "MAKSIMAALNE PERIOOD ANNUSTAMISE VAHEL. If present, indicates that the period is a range from [period] to [periodMax], allowing expressing concepts such as \"do this once every 3-5 days."
      },
      {
        "id" : "Dosage.timing.repeat.dayOfWeek",
        "path" : "Dosage.timing.repeat.dayOfWeek",
        "short" : " If one or more days of week is provided, then the action happens only on the specified day(s).",
        "definition" : "NÄDALAPÄEV. If one or more days of week is provided, then the action happens only on the specified day(s)."
      },
      {
        "id" : "Dosage.timing.repeat.timeOfDay",
        "path" : "Dosage.timing.repeat.timeOfDay",
        "short" : "Specified time of day for action to take place.",
        "definition" : "PÄEVA OSA. Specified time of day for action to take place."
      },
      {
        "id" : "Dosage.timing.repeat.when",
        "path" : "Dosage.timing.repeat.when",
        "definition" : "MILLEGA SEOTUD. "
      },
      {
        "id" : "Dosage.timing.repeat.offset",
        "path" : "Dosage.timing.repeat.offset",
        "definition" : "PERIOOD ENNE VÕI PÄRAST. "
      },
      {
        "id" : "Dosage.asNeeded",
        "path" : "Dosage.asNeeded",
        "definition" : "VAJADUSEL"
      },
      {
        "id" : "Dosage.asNeededFor",
        "path" : "Dosage.asNeededFor",
        "max" : "1"
      },
      {
        "id" : "Dosage.site",
        "path" : "Dosage.site",
        "definition" : "KEHAPIIRKOND."
      },
      {
        "id" : "Dosage.route",
        "path" : "Dosage.route",
        "definition" : "MANUSTAMISVIIS. Loend Ravimiregistrist"
      },
      {
        "id" : "Dosage.method",
        "path" : "Dosage.method",
        "definition" : "MANUSTAMISMEETOD."
      },
      {
        "id" : "Dosage.doseAndRate",
        "path" : "Dosage.doseAndRate",
        "definition" : "ANNUS JA KIIRUS."
      },
      {
        "id" : "Dosage.doseAndRate.dose[x]",
        "path" : "Dosage.doseAndRate.dose[x]",
        "definition" : "RAVIMI KOGUS ANNUSE KOHTA. Loendis on koodid nagu näiteks TA -tablett, TK - tükk, CP- kapsel, MA - mõõtannus jne. Amount of medication per dose."
      },
      {
        "id" : "Dosage.doseAndRate.rate[x]",
        "path" : "Dosage.doseAndRate.rate[x]",
        "definition" : "MANUSTAMISE KIIRUS. Amount of medication per unit of time."
      },
      {
        "id" : "Dosage.maxDosePerPeriod",
        "path" : "Dosage.maxDosePerPeriod",
        "definition" : "MAKSIMAALNE ANNUS PERIOODIS. Upper limit on medication per unit of time."
      },
      {
        "id" : "Dosage.maxDosePerAdministration",
        "path" : "Dosage.maxDosePerAdministration",
        "definition" : "MAKSIMAALNE ANNUS ÜHE ANNUSTAMISE KOHTA. Upper limit on medication per administration."
      },
      {
        "id" : "Dosage.maxDosePerLifetime",
        "path" : "Dosage.maxDosePerLifetime",
        "definition" : "MAKSIMAALNE ANNUS ELUS. Upper limit on medication per lifetime of the patient."
      }
    ]
  }
}

```
