# ExtensionEETISDosageModification - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISDosageModification**

## Extension: ExtensionEETISDosageModification 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-dosage-modification | *Version*:1.0.0 |
| Draft as of 2024-08-23 | *Computable Name*:ExtensionEETISDosageModification |

Annustamise soovitused. Recommendation for dosaging

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISRenalFailureDS](StructureDefinition-ee-tis-renal-failure-ds.md)
* Examples for this Extension: [ClinicalUseDefinition/renal-function-failure](ClinicalUseDefinition-renal-function-failure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-dosage-modification)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-dosage-modification.csv), [Excel](StructureDefinition-ee-tis-dosage-modification.xlsx), [Schematron](StructureDefinition-ee-tis-dosage-modification.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-dosage-modification",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-dosage-modification",
  "version" : "1.0.0",
  "name" : "ExtensionEETISDosageModification",
  "status" : "draft",
  "date" : "2024-08-23T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Annustamise soovitused. Recommendation for dosaging",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ClinicalUseDefinition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Recommendation for dosaging",
        "definition" : "Annustamise soovitused."
      },
      {
        "id" : "Extension.extension:dosageIntervalMin",
        "path" : "Extension.extension",
        "sliceName" : "dosageIntervalMin",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:dosageIntervalMin.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:dosageIntervalMin.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "dosageIntervalMin"
      },
      {
        "id" : "Extension.extension:dosageIntervalMin.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Minimum dosage interval in hours",
        "definition" : "Minimaalne annustamiseintervall tundides",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "Extension.extension:dosageIntervalMax",
        "path" : "Extension.extension",
        "sliceName" : "dosageIntervalMax",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:dosageIntervalMax.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:dosageIntervalMax.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "dosageIntervalMax"
      },
      {
        "id" : "Extension.extension:dosageIntervalMax.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Maximum dosage interval in hours",
        "definition" : "Maksimaalne annustamiseintervall tundides",
        "type" : [
          {
            "code" : "Quantity",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/SimpleQuantity"]
          }
        ]
      },
      {
        "id" : "Extension.extension:recommendation",
        "path" : "Extension.extension",
        "sliceName" : "recommendation",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:recommendation.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:recommendation.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "recommendation"
      },
      {
        "id" : "Extension.extension:recommendation.value[x]",
        "path" : "Extension.extension.value[x]",
        "short" : "Recommendation how to reduce undesired effect of medication",
        "definition" : "Soovitused annustamiseks",
        "type" : [
          {
            "code" : "string"
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-dosage-modification"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
