# ExtensionEETISConsentWithInteractions - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISConsentWithInteractions**

## Extension: ExtensionEETISConsentWithInteractions 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-consent-with-interactions | *Version*:1.0.0 |
| Draft as of 2024-02-23 | *Computable Name*:ExtensionEETISConsentWithInteractions |

Nõusolek koostoimetega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered the interactions and consented with them.

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationList](StructureDefinition-ee-tis-medication-list.md)
* Examples for this Extension: [List/listMatiMeri3](List-listMatiMeri3.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-consent-with-interactions)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-consent-with-interactions.csv), [Excel](StructureDefinition-ee-tis-consent-with-interactions.xlsx), [Schematron](StructureDefinition-ee-tis-consent-with-interactions.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-consent-with-interactions",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-consent-with-interactions",
  "version" : "1.0.0",
  "name" : "ExtensionEETISConsentWithInteractions",
  "status" : "draft",
  "date" : "2024-02-23T08:41:33.7774358+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Nõusolek koostoimetega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered the interactions and consented with them.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "List"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Consent with medication interactions.",
        "definition" : "Nõusolek koostoimetega. This extension is used in EETISMedicationList profile to express whether or not the practitioner adding medicines considered the interactions and consented with them."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-consent-with-interactions"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Whether or not practitioner agrees with interactions. \r\n\r\nIf true indicates that practitioner is aware and agrees with medication interactions.",
        "definition" : "Ravimi väljakirjutaja nõusolek koostoimetega.",
        "type" : [
          {
            "code" : "boolean"
          }
        ]
      }
    ]
  }
}

```
