# EETISCommunication - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EETISCommunication**

## Resource Profile: EETISCommunication 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-communication | *Version*:1.0.0 |
| Draft as of 2025-03-12 | *Computable Name*:EETISCommunication |

 
Ravimiskeemi kommentaar. Comment about one treatment line in mediction list. 

**Usages:**

* Examples for this Profile: [Communication/Comment-changed](Communication-Comment-changed.md), [Communication/Comment1](Communication-Comment1.md) and [Communication/comment-renal-failure](Communication-comment-renal-failure.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-communication)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-communication.csv), [Excel](StructureDefinition-ee-tis-communication.xlsx), [Schematron](StructureDefinition-ee-tis-communication.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-communication",
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-communication",
  "version" : "1.0.0",
  "name" : "EETISCommunication",
  "status" : "draft",
  "date" : "2025-03-12T13:55:03.1985103+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Ravimiskeemi kommentaar. Comment about one treatment line in mediction list.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Communication",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Communication",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Communication",
        "path" : "Communication",
        "short" : "Comment",
        "definition" : "Kommentaar"
      },
      {
        "id" : "Communication.identifier",
        "path" : "Communication.identifier",
        "short" : "ID of the comment",
        "definition" : "Kommentaari ID"
      },
      {
        "id" : "Communication.status",
        "path" : "Communication.status",
        "short" : "Status of the comment can be completed(LISATUD) or stopped(KUSTUTATUD). If comment is changed the note element is used.",
        "definition" : "Kasutusel 2 staatust LISATUD=completed, KUSTUTATUD=stopped. Kui tegu on muutmisega, tuleb see välja note.time elemendi muutmise aja ja teksti kaudu. "
      },
      {
        "id" : "Communication.category",
        "path" : "Communication.category",
        "short" : "The type of comment this is. Codes |alert| or |notification| are used",
        "definition" : "Kommentaari tüüp, nt neerufunktsiooni mõjutav ravimi puhul on koodiks |alert|",
        "min" : 1,
        "max" : "1",
        "binding" : {
          "strength" : "example",
          "description" : "|alert| is used when there is a renal failure of some degree and the health care professional needs to pay more attention to dosage",
          "valueSet" : "http://hl7.org/fhir/ValueSet/communication-category"
        }
      },
      {
        "id" : "Communication.category.text",
        "path" : "Communication.category.text",
        "short" : "Description of the alert",
        "definition" : "C/D. Siia tuleb hoiatus, kui ravim on neerutoksiline. Kui on tegu muu kommentaariga siis see väli on tühi"
      },
      {
        "id" : "Communication.about",
        "path" : "Communication.about",
        "short" : "Related MedicationStatement the comment is about",
        "definition" : "Ravimiskeemi rida, mille kohta kommentaar on tehtud",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "Communication.sent",
        "path" : "Communication.sent",
        "short" : "When the comment was added to the MedicationStatement",
        "definition" : "Kommentaari lisamise aeg",
        "min" : 1
      },
      {
        "id" : "Communication.sender",
        "path" : "Communication.sender",
        "short" : "Practitioner who added the comment",
        "definition" : "Tervishoiutöötaja, kes lisas ravimiskeemi reale kommentaari",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://fhir.ee/base/StructureDefinition/ee-practitioner",
              "https://fhir.ee/StructureDefinition/ee-tis-practitioner-role"
            ]
          }
        ]
      },
      {
        "id" : "Communication.reason",
        "path" : "Communication.reason",
        "short" : "Reference to a certain medication, its strenght and active ingredient this comment is about",
        "definition" : "Viide ravimile, ka toimeaine ja tugevus, mille kohta kommentaar on tehtud",
        "type" : [
          {
            "code" : "CodeableReference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/Medication"]
          }
        ]
      },
      {
        "id" : "Communication.payload",
        "path" : "Communication.payload",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Communication.payload.content[x]",
        "path" : "Communication.payload.content[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Communication.payload.content[x]:contentCodeableConcept",
        "path" : "Communication.payload.content[x]",
        "sliceName" : "contentCodeableConcept",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Communication.payload.content[x]:contentCodeableConcept.text",
        "path" : "Communication.payload.content[x].text",
        "short" : "Comment about the MedicationStatement in free form text",
        "definition" : "Kommentaari sisu vabatekstina",
        "min" : 1
      },
      {
        "id" : "Communication.note",
        "path" : "Communication.note",
        "type" : [
          {
            "code" : "Annotation",
            "profile" : ["https://fhir.ee/StructureDefinition/ee-tis-annotation"]
          }
        ]
      },
      {
        "id" : "Communication.note.time",
        "path" : "Communication.note.time",
        "short" : "Time when the comment was changed.",
        "definition" : "Kommentaari muutmise aeg",
        "min" : 1
      },
      {
        "id" : "Communication.note.text",
        "path" : "Communication.note.text",
        "short" : "Why the comment was changed",
        "definition" : "Kommentaari muutmise põhjendus"
      }
    ]
  }
}

```
