# ExtensionEETISCancelledStatusReason - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ExtensionEETISCancelledStatusReason**

## Extension: ExtensionEETISCancelledStatusReason 

| | |
| :--- | :--- |
| *Official URL*:https://fhir.ee/StructureDefinition/ee-tis-cancelled-status-reason | *Version*:1.0.0 |
| Draft as of 2024-01-31 | *Computable Name*:ExtensionEETISCancelledStatusReason |

Annulleerimise põhjus. Extension for describing the reason of 'cancelled' status of prescription

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [EETISMedicationStatement](StructureDefinition-ee-tis-medication-statement.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/ig-ee-medication-scheme|current/StructureDefinition/ee-tis-cancelled-status-reason)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-ee-tis-cancelled-status-reason.csv), [Excel](StructureDefinition-ee-tis-cancelled-status-reason.xlsx), [Schematron](StructureDefinition-ee-tis-cancelled-status-reason.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "ee-tis-cancelled-status-reason",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics",
      "valueCode" : "can-bind"
    }
  ],
  "url" : "https://fhir.ee/StructureDefinition/ee-tis-cancelled-status-reason",
  "version" : "1.0.0",
  "name" : "ExtensionEETISCancelledStatusReason",
  "status" : "draft",
  "date" : "2024-01-31T13:55:03.1985103+00:00",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Annulleerimise põhjus. Extension for describing the reason of 'cancelled' status of prescription",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "fhirVersion" : "5.0.0",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "MedicationStatement"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Reason for cancelling the prescription.",
        "definition" : "Annulleerimise põhjus"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://fhir.ee/StructureDefinition/ee-tis-cancelled-status-reason"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "short" : "Coded reason for cancelling the prescription.",
        "definition" : "Annulleerimise põhjus. Kui retsept annulleeritakse, tuleb loendist valida põhjus.",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "https://fhir.ee/ValueSet/retsepti-annulleerimise-pohjus"
        }
      }
    ]
  }
}

```
