# PractRoleN98765 - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **PractRoleN98765**

## Example PractitionerRole: PractRoleN98765

Language: et

Profile: [EEBase PractitionerRole](https://fhir.ee/packages/ee-base/2.0.0/site/StructureDefinition-ee-practitioner-role.html)

**active**: true

**period**: 2012-01-01 --> (ongoing)

**practitioner**: [Practitioner Laura Õde](Practitioner-N98765.md)

**organization**: [Organization Rakvere Haigla](Organization-rh.md)

**code**: Nurse, Õde

**specialty**: Kliiniline õendus



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "PractRoleN98765",
  "meta" : {
    "profile" : [
      "https://fhir.ee/base/StructureDefinition/ee-practitioner-role"
    ]
  },
  "language" : "et",
  "active" : true,
  "period" : {
    "start" : "2012-01-01"
  },
  "practitioner" : {
    "reference" : "Practitioner/N98765"
  },
  "organization" : {
    "reference" : "Organization/rh"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "http://terminology.hl7.org/CodeSystem/practitioner-role",
          "code" : "nurse",
          "display" : "Nurse"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ee-occupation",
          "code" : "22210502",
          "display" : "Õde"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "https://fhir.ee/CodeSystem/ee-medre-specialty",
          "code" : "N200",
          "display" : "Kliiniline õendus"
        }
      ]
    }
  ]
}

```
