# pat1MatiMeri - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **pat1MatiMeri**

## Example Patient: pat1MatiMeri

Language: et

Profile: [EE MPI Patient Verified](https://fhir.ee/packages/mpi/1.5.0/site/StructureDefinition-ee-mpi-patient-verified.html)

Mati Meri (official) (no stated gender), DoB Unknown ( https://fhir.ee/sid/pid/est/ni#38301105216)

-------

| | |
| :--- | :--- |
| Active: | true |
| Other Id: | `https://fhir.ee/sid/pid/est/ppn`/K0307337 (, period: (?) --> 2023-12-28) |
| Contact Detail | Harju maakond, Tallinn, Lasnamäe linnaosa, Valukoja tn 10(work) |



## Resource Content

```json
{
  "resourceType" : "Patient",
  "id" : "pat1MatiMeri",
  "meta" : {
    "profile" : [
      "https://fhir.ee/mpi/StructureDefinition/ee-mpi-patient-verified"
    ]
  },
  "language" : "et",
  "identifier" : [
    {
      "system" : "https://fhir.ee/sid/pid/est/ni",
      "value" : "38301105216"
    },
    {
      "system" : "https://fhir.ee/sid/pid/est/ppn",
      "value" : "K0307337",
      "period" : {
        "end" : "2023-12-28"
      },
      "assigner" : {
        "display" : "Estonian Police and Board Agency"
      }
    }
  ],
  "active" : true,
  "name" : [
    {
      "use" : "official",
      "family" : "Meri",
      "given" : ["Mati"]
    }
  ],
  "address" : [
    {
      "extension" : [
        {
          "url" : "https://fhir.ee/base/StructureDefinition/ee-ehak",
          "valueCoding" : {
            "system" : "https://fhir.ee/base/ehak",
            "code" : "0387"
          }
        },
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/address-official",
          "valueBoolean" : true
        }
      ],
      "use" : "work",
      "text" : "Harju maakond, Tallinn, Lasnamäe linnaosa, Valukoja tn 10",
      "city" : "Tallinn",
      "state" : "Harju",
      "postalCode" : "14215",
      "country" : "EE"
    }
  ]
}

```
