# Task reimbursements - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Task reimbursements**

## OperationDefinition: Task reimbursements 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.ee/OperationDefinition/Task-reimbursements | *Version*:1.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Reimbursements |

 
The reimbursement operation is used to get possible reimbursement for given Medication. 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "Task-reimbursements",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://fhir.ee/OperationDefinition/Task-reimbursements",
  "version" : "1.0.0",
  "name" : "Reimbursements",
  "title" : "Task reimbursements",
  "status" : "active",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2024-03-13T11:30:00Z",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The reimbursement operation is used to get possible reimbursement for given Medication.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "reimbursements",
  "resource" : ["Task"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "input",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Task input containing Medication and MedicationStatement as contained resources",
      "type" : "Task"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Found reimbursements",
      "type" : "Task"
    }
  ]
}

```
