# Validate MedicationStatement business rules - Medication Scheme Implementation Guide v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Validate MedicationStatement business rules**

## OperationDefinition: Validate MedicationStatement business rules 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://fhir.ee/OperationDefinition/MedicationStatement-validate-custom | *Version*:1.0.0 | |
| *Standards status:*[Trial-use](http://hl7.org/fhir/R5/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:Custom Statement Validation |

 
Builds on the default validate, by running MedIN specific business rules and RK checks 



## Resource Content

```json
{
  "resourceType" : "OperationDefinition",
  "id" : "MedicationStatement-validate-custom",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "trial-use"
    }
  ],
  "url" : "https://fhir.ee/OperationDefinition/MedicationStatement-validate-custom",
  "version" : "1.0.0",
  "name" : "Custom Statement Validation",
  "title" : "Validate MedicationStatement business rules",
  "status" : "active",
  "kind" : "operation",
  "experimental" : false,
  "date" : "2024-09-02T00:00:00Z",
  "publisher" : "TEHIK",
  "contact" : [
    {
      "name" : "TEHIK",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.tehik.ee"
        },
        {
          "system" : "email",
          "value" : "fhir@tehik.ee"
        }
      ]
    },
    {
      "name" : "TEHIK Andmekorraldus",
      "telecom" : [
        {
          "system" : "email",
          "value" : "andmekorraldus@tehik.ee",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Builds on the default validate, by running MedIN specific business rules and RK checks",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "EE",
          "display" : "Estonia"
        }
      ]
    }
  ],
  "affectsState" : false,
  "code" : "validate-custom",
  "resource" : ["MedicationStatement"],
  "system" : false,
  "type" : true,
  "instance" : false,
  "parameter" : [
    {
      "name" : "input",
      "use" : "in",
      "min" : 1,
      "max" : "1",
      "documentation" : "Bundle of MedicationStatements and Medications",
      "type" : "Bundle"
    },
    {
      "name" : "return",
      "use" : "out",
      "min" : 1,
      "max" : "1",
      "documentation" : "Occurred issues (if any)",
      "type" : "OperationOutcome"
    }
  ]
}

```
